/*///////(Copyright)//////(No modificar estas 11 primeras Lineas)/////////  */
/*     Autor: Antonio Castro Snurmacher (E-mail <acastro@ctv.es> )          */
/*                                                                          */
/*  Este fuente puede ser utilizado, distribuido, y modificado libremente   */
/*  pero siempre se deber respetar la propiedad intelectual de su autor.   */
/*  El autor renuncia a todo tipo de beneficio econmico y no se hace       */
/*  responsable de los posibles perjuicios derivados del uso del mismo.     */
/*  Toda modificacin queda sujeta a las mismas condiciones de uso que el   */
/*  original. En caso de traduccin deber conservarse el texto original    */
/*  de esta cabecera y aadirse la traduccin a continuacin de ella.       */
/*//////////////////////////////////////////////////////////////////////////*/

/*--------------------------------------------------------------------------*/
/*     burbujas.c  (1-Mayo-1998)                                            */
/*--------------------------------------------------------------------------*/
/*  Esta versin esta dedicada a su inclusin en la revista LinuxFocus      */
/*--------------------------------------------------------------------------*/


/*************************************************************/
/**    Compilar mediante cc balls.c -lm -o balls            **/
/*************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#define MAX_X       1000.0
#define MAX_Z        750.0
#define MAX_BALLS   10000
#define MIN_RAD     3.0
#define MAX_RAD     55.0

double PosX[MAX_BALLS];
double PosZ[MAX_BALLS];
double Rad[MAX_BALLS];
int contBall=0;
int contIter=0;
int i;

/*****************************************/
void intento(double x, double z, int cont){
   double distX2;
   double distZ2;
   double rad, cur_rad;

   contIter++;
   rad=MAX_RAD;
   for (i=0; i<contBall; i++){
        distX2  = x - PosX[i];
        distX2 *= distX2;
        distZ2  = z - PosZ[i];
        distZ2 *= distZ2;
        cur_rad=sqrt(distX2 + distZ2)-Rad[i];
        if (cur_rad < rad)
		rad=cur_rad;
   }
   if (rad > MAX_RAD)
         rad = MAX_RAD;
   if (rad >= MIN_RAD ){
       Rad[contBall]=rad;
       PosX[contBall]=x;
       PosZ[contBall]=z;
       printf("sphere { <%4.0f, 0, %4.0f> %3.7f texture { textureBall } } //(%d/%d)\n", x, z, rad, contBall,contIter);
       contBall++;
       if ( (contBall >= MAX_BALLS) )  ){
              exit(0);
       }
          else{
              return;   /** Siguiente bola **/
          }
   }
   return; /** fallo nuevo intento **/
}

/****************************************/
int r_rand(int m){
   return (int) ( (double)m * rand()/(RAND_MAX+1.0));
}

/****************************************/
main (){
  int X, Z;

  for(;;){
        X=r_rand(MAX_X);
        Z=r_rand(MAX_Z);
	X -= MAX_X/2;
	Z -= MAX_Z/2;
        intento(X, Z, contBall);
   }
}
