
/* Copyright (c) Miguel Angel Sepulveda, 1998. */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#include "Gd_noise.h"  
 
#define IA 16807   
#define IM 2147483647   
#define AM (1.0F/IM)   
#define IQ 127773   
#define IR 2836   
#define MASK 123459876   
 
 
double ran0(long *idum) {   
/* Returns a uniform random deviate between 0.0 and 1.0.   
Set or reset idum to any integer value to initialize sequence   
  */   
  long k;   
  float ans;   
	  
  *idum ^= MASK;   
  k = (*idum)/IQ;   
  *idum = IA *(*idum-k*IQ)-IR*k;   
  if (*idum < 0) *idum += IM;   
  ans = (float)AM*(*idum);   
  *idum ^= MASK;   
  return ans;   
};   
 
double ranGauss0(unsigned long *idum){   
  int i;   
  double a1 = 3.949846138;   
  double a3 = 0.252408784;   
  double a5 = 0.076542912;   
  double a7 = 0.008355968;   
  double a9 = 0.029899776;   
  double R = -6.0;   
  double R2;   
  double rand;   
  for(i = 0; i < 12; i++) R += ran1(idum);   
  R /= 4.0;   
  R2 = R * R;   
  rand = ((((a9 * R2 +a7)*R2 + a5)*R2 + a3)*R2 + a1)*R;   
  return rand;   
};   
 
 
