
/*--------------------------------------------------------------------*/
/*--- Architecture-specific system call details  vg_arch_syscall.h ---*/
/*--------------------------------------------------------------------*/

/*
   This file is part of Valgrind, an extensible
   emulator for monitoring program execution on Linux.

   Copyright (C) 2000-2004 Julian Seward 
      jseward@acm.org
   Copyright (C) 2004 Paul Mackerras
      paulus@samba.org

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.

   The GNU General Public License is contained in the file COPYING.
*/

#define ARCH_DO_MMAP(ret, start, length, prot, flags, fd, offset) {	\
   ret = VG_(do_syscall)(__NR_mmap, (UInt)(start), (length),		\
			 (prot), (flags), (fd), (offset));		\
}

#define ARCH_GET_MMAP_ARGS(tst, a1, a2, a3, a4, a5, a6) do {	\
   a1 = ARCH_SYSCALL_ARG1(tst->arch);				\
   a2 = ARCH_SYSCALL_ARG2(tst->arch);				\
   a3 = ARCH_SYSCALL_ARG3(tst->arch);				\
   a4 = ARCH_SYSCALL_ARG4(tst->arch);				\
   a5 = ARCH_SYSCALL_ARG5(tst->arch);				\
   a6 = ARCH_SYSCALL_ARG6(tst->arch);				\
} while (0)

/* XXX need a better place for these */
#define SIGCONTEXT_EIP(sc)	((sc).nip)
#define SIGCONTEXT_SYSNR(sc)	((sc).gpr[3])

/* How to get from a ucontext to the register values it contains */
#define UCONTEXT_REGS(uc)	((uc).uc_regs)

#define ARCH_DO_SYSCALL_DIRECT(sysnr, tst) {	\
   VG_(do_syscall_direct)(sysnr, tst);		\
} while (0)

extern void VG_(do_syscall_direct)(Int sysnr, arch_thread_t *tp);
