# This script will perform required test on pthreads library

#---
# Store directory where we started...
#---
$init_dir = Dir.pwd

#---
#
#---
def usage_and_exit(msg)
    print "\n"
    print "-----\n"
    print "error: #{msg}!\n"
    print "-----\n"
    print "usage: #{__FILE__} src_dir test_dir pthr_mak ptst_mak target\n"
    print "   src_dir : source test directory\n"
    print "   test_dir: where the tests are to be performed\n"
    print "   pthr_mak: pthreads makefile to be used in the build\n"
    print "   ptst_mak: pthreads/tests makefile to be used in the build\n"
    print "   target  : either VSE or VCE target of pthreads build\n"
    print "-----\n\n"
    Dir.chdir $init_dir if Dir.pwd != $init_dir
    exit
end


#---
#
#---
def show_header(num, msg)
    print "\n"
    print "       /=" + "=" * msg.length() + "=\\\n"
    printf("(%02d)---| %s |\n", num, msg)
    print "       \\=" + "=" * msg.length() + "=/\n"
end


#-------------
# Main program
#-------------

# check given command-line parameters
usage_and_exit("Not enough parameters") if ARGV.size != 5
usage_and_exit("Source directory does not exist") if !FileTest.directory? ARGV[0]
usage_and_exit("Test directory already exists") if FileTest.exist? ARGV[1]
usage_and_exit("pthreads makefile does not exist") if !FileTest.readable? ARGV[2]
usage_and_exit("pthreads/tests makefile does not exist") if !FileTest.readable? ARGV[3]
usage_and_exit("Unrecognized build target") if ARGV[4] != "VSE" and ARGV[4] != "VCE"

# copy source dir to the test dir
show_header 1, "Copying src to test"
usage_and_exit("Copying failed") \
    unless system "xcopy /Q /E /I /H /Y #{ARGV[0]} #{ARGV[1]}"
print "Done\n\n"

# copy source dir to the test dir
show_header 2, "Propagating makefiles"
usage_and_exit("pthreads makefile propagation failed") \
    unless system "xcopy /Q /H /Y #{ARGV[2]} #{ARGV[1]}\\Makefile"
usage_and_exit("pthreads/tests makefile propagation failed") \
    unless system "xcopy /Q /H /Y #{ARGV[3]} #{ARGV[1]}\\tests\\Makefile"
print "Done\n\n"

# run compilation of pthreads library
Dir.chdir ARGV[1]
show_header 3, "Compiling pthreads library"
usage_and_exit("pthreads make failed") \
    unless system "nmake -nologo realclean #{ARGV[4]}"
print "Done\n\n"

# run pthreads library tests
Dir.chdir "tests"
show_header 3, "Compiling & running pthreads tests"
usage_and_exit("pthreads tests make failed") \
    unless system "nmake -nologo clean #{ARGV[4]}"
print "Done\n\n"

# restore original environment
Dir.chdir $init_dir if Dir.pwd != $init_dir
