/*
 * tools/lib/lvm_check_partitioned_dev.c
 *
 * Copyright (C) 1999 - 2001 Heinz Mauelshagen, Sistina Software
 *
 * March,July,August 1999
 * January,April 2000
 * February 2001
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    05/07/1999 - added 2.3.x new IDE majors
 *    20/08/1999 - added DAC960 majors
 *    31/01/2000 - use debug_enter()/debug_leave()
 *    26/04/2000 - added DASD major support
 *    07/02/2001 - added COMPAQ_CISS & SMART2 major support
 *    17/08/2001 - added dynamic major support (Stefan Bader)
 *
 */

#include <liblvm.h>

int lvm_partition_count(dev_t);

const lvm_device_type_t lvm_get_device_type(dev_t device);

int lvm_check_partitioned_dev(dev_t st_rdev)
{
    int ret = FALSE;

    debug_enter("lvm_check_partitioned_dev -- CALLED\n");

    if (st_rdev == 0)
	ret = -LVM_EPARAM;
    else {
	switch (lvm_get_device_type(st_rdev)) {
	case LVM_DEVICE_TYPE_INVALID:
	    break;
	default:
	    ret = TRUE;
	}
    }

    debug_leave("lvm_check_partitioned_dev -- LEAVING with ret: %s\n",
		ret ? "TRUE" : "FALSE");
    return ret;
}


int lvm_check_whole_disk_dev(dev_t st_rdev)
{
    int ret = UNDEF;

    debug_enter("lvm_check_whole_disk_dev -- CALLED\n");

    if (st_rdev == 0) {
	ret = -LVM_EPARAM;
    } else if ((MINOR(st_rdev) % lvm_partition_count(st_rdev)) == 0) {
	ret = TRUE;
    }

    debug_leave("lvm_check_whole_disk_dev -- LEAVING with ret: %s\n",
		ret ? "TRUE" : "FALSE");
    return ret;
}


/* st_rdev must be valid if you are not checking the return value */
int lvm_partition_count(dev_t st_rdev)
{
    int ret = -LVM_EPARAM;

    debug_enter("lvm_partition_count -- CALLED for 0x%x\n", st_rdev);

    if (st_rdev != 0) {
	switch (lvm_get_device_type(st_rdev)) {
	case LVM_DEVICE_TYPE_DASD:
	    ret = 4;
	    break;
	case LVM_DEVICE_TYPE_DAC960:
	    ret = 8;
	    break;
	default:
	    ret = 16;
	}
    }

    debug_leave("lvm_partition_count -- LEAVING with ret: %d\n", ret);
    return ret;
}


int lvm_check_extended_partition(dev_t st_rdev)
{
    int ret = FALSE;

    debug_enter("lvm_check_extended_partition -- CALLED\n");

    if (st_rdev == 0)
	ret = -LVM_EPARAM;
    else if (MINOR(st_rdev) % lvm_partition_count(st_rdev) > 4)
	ret = TRUE;

    debug_leave("lvm_check_extended_partition -- LEAVING with ret: %d\n", ret);
    return ret;
}


const lvm_device_type_t lvm_get_device_type(dev_t device)
{
    char line[80];
    char *device_names[] = {
	"ide",			/* IDE disk              */
	"sd",			/* SCSI disk              */
	"md",			/* Multiple Disk driver (SoftRAID)   */
	"loop",			/* Loop device              */
	"dasd",			/* DASD disk (IBM S/390, zSeries)      */
	"dac960",		/* DAC960              */
	"nbd",			/* Network Block Device              */
	"ida",			/* Compaq SMART2              */
	"cciss",		/* Compaq CCISS array              */
	"ubd",			/* User-mode virtual block device */
	NULL
    };
    FILE *procdevices = NULL;
    int ret = LVM_DEVICE_TYPE_INVALID;
    int i, j = 0;
    int seek_major = MAJOR(device);
    int line_major = 0;
    int blocksection = 0;

    debug_enter("lvm_get_device_type called\n");

    /* FIXME Ought to cache this first time */
    if ((procdevices = fopen("/proc/devices", "r")) != NULL) {
	while (fgets(line, 80, procdevices) != NULL) {
	    i = 0;
	    while (line[i] == ' ' && line[i] != '\0')
		i++;

	    /* If its not a number it may be the name of the section */
	    line_major = atoi(((char *) (line + i)));
	    if (line_major == 0) {
		blocksection = (line[i] == 'B') ? 1 : 0;
		continue;
	    }
	    /* We only want block devices ... */
	    if (!blocksection)
		continue;

	    if (line_major == seek_major) {
		while (line[i] != ' ' && line[i] != '\0')
		    i++;
		while (line[i] == ' ' && line[i] != '\0')
		    i++;
		for (j = 0; device_names[j] != NULL; j++) {
		    if (strlen(device_names[j]) <= strlen(line + i)) {
			if (strncmp
			    (device_names[j], line + i,
			     strlen(device_names[j])) == 0) {
			    ret = j;
			    break;
			}
		    }
		}
		break;
	    }
	}
	fclose(procdevices);
    }
    debug_leave("lvm_get_device_type leaving with %i\n", ret);
    return (ret);
}
