// String based streams -*- C++ -*-

// Copyright (C) 1997,1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

//
// ISO C++ 14882: 27.7  String-based streams
//

#ifndef _CPP_SSTREAM
#define _CPP_SSTREAM	1

#include <bits/c++config.h>
#include <bits/std_ios.h>
#include <bits/std_streambuf.h>
#include <bits/std_istream.h>
#include <bits/std_ostream.h>

namespace std {

  template <class _CharT, class _Traits, class _Alloc>
  class basic_stringbuf : public basic_streambuf<_CharT,_Traits>
  {
  public:
    // Types:
    typedef _CharT char_type;
    typedef typename _Traits::int_type int_type;
    typedef typename _Traits::pos_type pos_type;
    typedef typename _Traits::off_type off_type;
    typedef _Traits                    traits_type;

    // Constructors:
    explicit basic_stringbuf (ios_base::openmode __which = (ios_base::in
							  | ios_base::out))
      : basic_streambuf<_CharT,_Traits> (), _M_mode (__which) { }
    explicit basic_stringbuf(
        const basic_string<_CharT,_Traits,_Alloc>& __str,
        ios_base::openmode __which = (ios_base::in | ios_base::out));

    // Get and set:
    basic_string<_CharT,_Traits,_Alloc> str () const;
    void str (const basic_string<_CharT,_Traits,_Alloc>& __s);

  protected:
    // Overridden virtual functions:
    virtual int_type underflow ();
    virtual int_type pbackfail (int_type __c = _Traits::eof ());
    virtual int_type overflow (int_type __c = _Traits::eof ());
    virtual basic_streambuf<_CharT,_Traits>* setbuf (_CharT*, streamsize);

    virtual pos_type seekoff (off_type __off, ios_base::seekdir __way,
			      ios_base::openmode __which = (ios_base::in
							  | ios_base::out));
    virtual pos_type seekpos (pos_type __sp,
			      ios_base::openmode __which = (ios_base::in
							  | ios_base::out));
  private:
    ios_base::openmode _M_mode;
  };

  typedef basic_stringbuf<char> stringbuf;
  typedef basic_stringbuf<wchar_t> wstringbuf;


  // 27.7.2  Template class basic_istringstream
  template <class _CharT, class _Traits, class _Alloc>
  class basic_istringstream : public basic_istream<_CharT,_Traits>
  {
  public:
    // Types:
    typedef _CharT char_type;
    typedef typename _Traits::int_type int_type;
    typedef typename _Traits::pos_type pos_type;
    typedef typename _Traits::off_type off_type;
    typedef _Traits                    traits_type;

    // Constructors:
    explicit basic_istringstream (ios_base::openmode __which = ios_base::in)
      : basic_istream<_CharT, _Traits> (&_M_sb),
       _M_sb (basic_stringbuf<_CharT,_Traits,_Alloc> (__which | ios_base::in))
       { }

    explicit basic_istringstream (
      const basic_string<_CharT,_Traits,_Alloc>& __str,
      ios_base::openmode __which = ios_base::in)
      : basic_istream<_CharT, _Traits> (&_M_sb),
       _M_sb (basic_stringbuf<_CharT,_Traits,_Alloc> (__str, __which | ios_base::in))
      { }

    // Members:
    basic_stringbuf<_CharT,_Traits,_Alloc>* rdbuf () const
      { return &_M_sb; }

    basic_string<_CharT,_Traits,_Alloc> str () const
      { return rdbuf() -> str(); }
  
    void str (const basic_string<_CharT,_Traits,_Alloc>& __s)
      { return rdbuf() -> str(__s); }

  private:
    basic_stringbuf<_CharT,_Traits,_Alloc> _M_sb;
  };

  typedef basic_istringstream<char> istringstream;
  typedef basic_istringstream<wchar_t> wistringstream;

  // 27.7.3  Template class basic_ostringstream
  template <class _CharT, class _Traits, class _Alloc>
  class basic_ostringstream : public basic_ostream<_CharT,_Traits>
  {
  public:
    // Types:
    typedef _CharT char_type;
    typedef typename _Traits::int_type int_type;
    typedef typename _Traits::pos_type pos_type;
    typedef typename _Traits::off_type off_type;
    typedef _Traits                    traits_type;

    // Constructors/destructor:
    explicit basic_ostringstream (ios_base::openmode __which = ios_base::out)
      : basic_ostream<_CharT,_Traits> (&_M_sb),
       _M_sb (basic_stringbuf<_CharT,_Traits,_Alloc>(__which | ios_base::out))
      { }

    explicit basic_ostringstream(
      const basic_string<_CharT,_Traits,_Alloc>& __str,
      ios_base::openmode __which = ios_base::out)
      : basic_ostream<_CharT,_Traits> (&_M_sb),
       _M_sb (basic_stringbuf<_CharT,_Traits,_Alloc> (__str, __which | ios_base::out))
      { }

    virtual ~basic_ostringstream () {}

    // Members:
    basic_stringbuf<_CharT,_Traits,_Alloc>* rdbuf () const
      { return &_M_sb; }

    basic_string<_CharT,_Traits,_Alloc> str () const
     { return rdbuf() -> str(); }
 
    void str (const basic_string<_CharT,_Traits,_Alloc>& __s)
      { return rdbuf() -> str(__s); }

  private:
    basic_stringbuf<_CharT,_Traits,_Alloc> _M_sb;
  };

  typedef basic_ostringstream<char> ostringstream;
  typedef basic_ostringstream<wchar_t> wostringstream;

  // 27.7.4  Template class basic_stringstream
  template <class _CharT, class _Traits, class _Alloc>
  class basic_stringstream : public basic_iostream<_CharT,_Traits>
  {
  public:
    // Types
    typedef _CharT char_type;
    typedef typename _Traits::int_type int_type;
    typedef typename _Traits::pos_type pos_type;
    typedef typename _Traits::off_type off_type;
    typedef _Traits                    traits_type;

    // Constructors/destructors
    explicit basic_stringstream(
      ios_base::openmode __which = (ios_base::out | ios_base::in))
      : basic_iostream<_CharT,_Traits> (&_M_sb),
        _M_sb (basic_stringbuf<_CharT,_Traits,_Alloc> (__which))
      { }

    explicit basic_stringstream(
      const basic_string<_CharT,_Traits,_Alloc>& __str,
      ios_base::openmode __which = (ios_base::out | ios_base::in))
      : basic_iostream<_CharT,_Traits> (&_M_sb),
       _M_sb (basic_stringbuf<_CharT,_Traits,_Alloc> (__str, __which))
      { }

    // Members:
    basic_stringbuf<_CharT,_Traits,_Alloc>* rdbuf () const
     { return &_M_sb; }

    basic_string<_CharT,_Traits,_Alloc> str () const
      { return rdbuf() -> str(); }

    void str (const basic_string<_CharT,_Traits,_Alloc>& __str)
     { return rdbuf() -> str(__s); }

  private:
    basic_stringbuf<_CharT,_Traits> _M_sb;
  };

  typedef basic_stringstream<char> stringstream;
  typedef basic_stringstream<wchar_t> wstringstream;

} // namespace std

#endif	/* _CPP_SSTREAM */









