/*
 * graph.h
 * and connected components (disjoint sets)
 */

#define BALSCHED
#ifdef BALSCHED

#define DIFFERENT_SETS 0
#define SAME_SET       1

#define NOT_REMOVED 0
#define REMOVED     1
#define VISITED     3

#define WHITE       0
#define GRAY        1
#define BLACK       2

#define NOT_LEAF    0
#define IS_LEAF     1

#define CC_MAX_LEVEL_INIT 0
#define CC_MIN_LEVEL_INIT 10000

#define INITIAL_STACK_SIZE   8

#define TURN_OFF_BSA 1
#define TURN_ON_BSA 0

#define MISS_PENALTY 10
/*#include "rtl.h"*/

typedef struct cc_info_def
{
  /* The number of loads in this connected component (disjoint set) */
  int num_loads;
  int cc_num;
  int min_level;
  int max_level;
} *cc_info;

/* Need to have pointer to the element itself so that we can 
   update the set_obj pointers ??*/

typedef struct set_obj_def
{
  struct set_obj_def *parent; 
  int                 rank;

  /* If non-NULL, points to the info about this connected component */
  cc_info             cc;
  int                 representative:1;   
  /* The rtx with which this set object is associated */
  rtx                 insn;
  int                 visited:1;
  int                 level;     /* Each load adds a new level */
} *set_obj;

typedef struct set_list_def
{
  rtx *elem;                    /* element in the set */
  struct set_list_def *next;    /* next element in the set */
} *set_list;

typedef struct disjoint_set_def
{
  rtx *set_rep;        /* pointer to set representative */
  set_list  list;
} *d_set;

typedef struct stack_def
{
  rtx *pContents;
  int currentSize;
  int maxSize;
} *stack;

#ifdef USE_PROTOS
void create_inv_links(rtx tail, rtx prev_head);

void unremove_all(rtx tail, rtx prev_head);

void remove_predecessors (rtx insn);

void remove_successors (rtx insn);

void init_priorities(rtx tail, rtx prev_head);

void graph_init (rtx tail, rtx prev_head);

set_obj set_obj_alloc();
set_obj make_set (rtx insn);
set_obj find_set (set_obj obj);
void link_sets (set_obj set1, set_obj set2);
int union_sets (set_obj set1, set_obj set2);
void print_insns (rtx tail, rtx prev_head);
void free_connected_components (rtx tail, rtx prev_head);
int longest_load_path (rtx insn);
int is_leaf (rtx insn);
void init_levels (rtx tail, rtx prev_head);
void assign_levels (rtx tail, rtx prev_head);
void traverse (rtx insn, int level);
void print_priorities (rtx tail, rtx prev_head);
void clear_visited_flags (rtx tail, rtx prev_head);
void create_sets (rtx tail, rtx prev_head);

stack stack_create ();
void stack_push (stack st, rtx insn);
rtx stack_pop (stack st);
int stack_empty (stack st);
void stack_free (stack st);
void stack_print (stack st);

void graph_split_insns (rtx insns);
rtx graph_delete_notes (rtx rtx_first);
 
void output_xgrab_file (rtx tail, rtx prev_head);

#ifdef CACHE_OPT
void loads_turn_off_bsa (predicate p);
void loads_turn_on_bsa (predicate p);
void load_set_bsa (predicate p, int option);
void find_load_for_predicate (predicate p);
#endif

void stack_free (stack st);
void stack_print (stack st);

void graph_split_insns (rtx insns);
rtx graph_delete_notes (rtx rtx_first);
 
void output_xgrab_file (rtx tail, rtx prev_head);

#ifdef CACHE_OPT
void loads_turn_off_bsa (predicate p);
void loads_turn_on_bsa (predicate p);
void load_set_bsa (predicate p, int option);
void find_load_for_predicate (predicate p);
#endif

#else /* USE_PROTOS */
void create_inv_links();

void unremove_all();

void remove_predecessors ();

void remove_successors ();

void init_priorities();

void graph_init ();

set_obj set_obj_alloc();
set_obj make_set ();
set_obj find_set ();
void link_sets ();
int union_sets ();
void print_insns ();
void free_connected_components ();
int longest_load_path ();
int is_leaf ();
void init_levels ();
void assign_levels ();
void traverse ();
void print_priorities ();
void clear_visited_flags ();
void create_sets ();

stack stack_create ();
void stack_push ();
rtx stack_pop ();
int stack_empty ();
void stack_free ();
void stack_print ();

void graph_split_insns ();
rtx graph_delete_notes ();
 
void output_xgrab_file ();

#ifdef CACHE_OPT
void loads_turn_off_bsa ();
void loads_turn_on_bsa ();
void load_set_bsa ();
void find_load_for_predicate ();
#endif

void stack_free ();
void stack_print ();

void graph_split_insns ();
rtx graph_delete_notes ();
 
void output_xgrab_file ();

#ifdef CACHE_OPT
void loads_turn_off_bsa ();
void loads_turn_on_bsa ();
void load_set_bsa ();
void find_load_for_predicate ();
#endif

#endif /* USE_PROTOS */
#endif
