//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that if a default constructor is needed (e.g. at the point
// where an object is created) and that if there is a constructor
// which takes zero arguments but which is private, a reasonable
// error message is issued.
//
// Cases: objects which are:
//	static
//	auto
//	heap
//
// Cases: objects of:
//	a type which has a private default constructor

class friendly;

class base
{
	base();
	friend class friendly;
public:
	int data_member;
	void function_member ();
};

static base static_base_object_1;		// ERROR
base static_base_object_2;			// ERROR

base* base_ptr;

void test1 ()
{
	base local_base_object;			// ERROR

	base_ptr = new base;			// ERROR
	local_base_object.data_member = 99;
	local_base_object.function_member ();
}
