//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that it is illegal to declare global unary operators with
// more than one explicit formal argument.
//
// Note that operator-> must be a member function, so it is not
// tested here.

typedef unsigned long size_t;

struct st {
	int member;
};

struct st2 {
	int member;
};

// Unary + could be binary
//int operator + (st so1, st so2);

// unary - could be binary
//int operator - (st so1, st so2);

// unary & could be binary
//int operator & (st so1, st so2);

// unary * could be binary
//int operator * (st so1, st so2);

int operator ~ (st so1, st so2);		// ERROR

int operator ! (st so1, st so2);		// ERROR

int operator ++ (st so1, st so2);		// ERROR

int operator -- (st so1, st so2);		// ERROR

//int operator -> (st so1, st so2);		// must be a member

void* operator new (size_t so1, size_t so2);	// OK - can take additional args

void operator delete (void* so1, void* so2);	// ERROR

operator st (st so1, st so2);			// ERROR

operator st2 (st so1, st so2);			// ERROR

operator int (st so1, st so2);			// ERROR
