#include <cyg/infra/cyg_type.h>

struct libio_handler_t
{
  int (*read)(int fd, void *buffer, cyg_uint32 count);
  int (*write)(int fd, const void *buffer, cyg_uint32 count);
  int (*ioctl)(int fd, cyg_uint32 command, void *buffer);
  int (*close)(int fd);
};

/* Get a new fd for a registred handler.  */
extern int libio_get_fd (struct libio_handler_t *handler, void *data);

/* Get the data from an fd.  */
/* Return NULL if fd is bad.  */
extern void *libio_get_data (int fd);

/* Initialize.  Open fd 0, 1, 2.  */
void libio_initialize (void);
