;;; DO NOT MODIFY THIS FILE
(if (featurep 'tramp-autoloads) (error "Already loaded"))

;;;### (autoloads nil "_pkg" "lisp/_pkg.el")

(package-provide 'tramp :version 1.57 :author-version "2.2.13" :type 'regular)

;;;***

;;;### (autoloads (tramp-unload-tramp tramp-completion-handle-file-name-completion tramp-completion-handle-file-name-all-completions tramp-unload-file-name-handlers tramp-syntax tramp-mode) "tramp" "lisp/tramp.el")

(defvar tramp-mode t "\
Whether Tramp is enabled.
If it is set to nil, all remote file names are used literally.")

(defvar tramp-syntax (if (featurep 'xemacs) 'sep 'ftp) "\
Tramp filename syntax to be used.

It can have the following values:

  `ftp' -- Ange-FTP respective EFS like syntax (GNU Emacs default)
  `sep' -- Syntax as defined for XEmacs.")

(defconst tramp-file-name-regexp-unified (if (memq system-type '(cygwin windows-nt)) "\\`/\\(\\[.*\\]\\|[^/|:]\\{2,\\}[^/|]*\\):" "\\`/[^/|:][^/|]*:") "\
Value for `tramp-file-name-regexp' for unified remoting.
Emacs (not XEmacs) uses a unified filename syntax for Ange-FTP and
Tramp.  See `tramp-file-name-structure' for more explanations.

On W32 systems, the volume letter must be ignored.")

(defconst tramp-file-name-regexp-separate "\\`/\\[.*\\]" "\
Value for `tramp-file-name-regexp' for separate remoting.
XEmacs uses a separate filename syntax for Tramp and EFS.
See `tramp-file-name-structure' for more explanations.")

(defconst tramp-file-name-regexp (cond ((equal tramp-syntax 'ftp) tramp-file-name-regexp-unified) ((equal tramp-syntax 'sep) tramp-file-name-regexp-separate) (t (error "Wrong `tramp-syntax' defined"))) "\
Regular expression matching file names handled by Tramp.
This regexp should match Tramp file names but no other file names.
When tramp.el is loaded, this regular expression is prepended to
`file-name-handler-alist', and that is searched sequentially.  Thus,
if the Tramp entry appears rather early in the `file-name-handler-alist'
and is a bit too general, then some files might be considered Tramp
files which are not really Tramp files.

Please note that the entry in `file-name-handler-alist' is made when
this file (tramp.el) is loaded.  This means that this variable must be set
before loading tramp.el.  Alternatively, `file-name-handler-alist' can be
updated after changing this variable.

Also see `tramp-file-name-structure'.")

(defconst tramp-completion-file-name-regexp-unified (if (memq system-type '(cygwin windows-nt)) "\\`/[^/]\\{2,\\}\\'" "\\`/[^/]*\\'") "\
Value for `tramp-completion-file-name-regexp' for unified remoting.
GNU Emacs uses a unified filename syntax for Tramp and Ange-FTP.
See `tramp-file-name-structure' for more explanations.

On W32 systems, the volume letter must be ignored.")

(defconst tramp-completion-file-name-regexp-separate "\\`/\\([[][^]]*\\)?\\'" "\
Value for `tramp-completion-file-name-regexp' for separate remoting.
XEmacs uses a separate filename syntax for Tramp and EFS.
See `tramp-file-name-structure' for more explanations.")

(defconst tramp-completion-file-name-regexp (cond ((equal tramp-syntax 'ftp) tramp-completion-file-name-regexp-unified) ((equal tramp-syntax 'sep) tramp-completion-file-name-regexp-separate) (t (error "Wrong `tramp-syntax' defined"))) "\
Regular expression matching file names handled by Tramp completion.
This regexp should match partial Tramp file names only.

Please note that the entry in `file-name-handler-alist' is made when
this file (tramp.el) is loaded.  This means that this variable must be set
before loading tramp.el.  Alternatively, `file-name-handler-alist' can be
updated after changing this variable.

Also see `tramp-file-name-structure'.")

(defconst tramp-completion-file-name-handler-alist '((file-name-all-completions . tramp-completion-handle-file-name-all-completions) (file-name-completion . tramp-completion-handle-file-name-completion)) "\
Alist of completion handler functions.
Used for file names matching `tramp-file-name-regexp'. Operations
not mentioned here will be handled by Tramp's file name handler
functions, or the normal Emacs functions.")

(progn (defun tramp-completion-run-real-handler (operation args) "Invoke `tramp-file-name-handler' for OPERATION.\nFirst arg specifies the OPERATION, second arg is a list of arguments to\npass to the OPERATION." (let* ((inhibit-file-name-handlers (backquote (tramp-completion-file-name-handler cygwin-mount-name-hook-function cygwin-mount-map-drive-hook-function \, (and (eq inhibit-file-name-operation operation) inhibit-file-name-handlers)))) (inhibit-file-name-operation operation)) (apply operation args))))

(progn (defun tramp-completion-file-name-handler (operation &rest args) "Invoke Tramp file name completion handler.\nFalls back to normal file name handler if no Tramp file name handler exists." (let ((directory-sep-char ?/) (fn (assoc operation tramp-completion-file-name-handler-alist))) (if (and fn tramp-mode (or (eq tramp-syntax 'sep) (featurep 'tramp) (and (boundp 'partial-completion-mode) (symbol-value 'partial-completion-mode)) (featurep 'ido) (featurep 'icicles))) (save-match-data (apply (cdr fn) args)) (tramp-completion-run-real-handler operation args)))))

(progn (defun tramp-autoload-file-name-handler (operation &rest args) "Load Tramp file name handler, and perform OPERATION." (let ((default-directory "/")) (load "tramp" nil t)) (apply operation args)))

(progn (defun tramp-register-autoload-file-name-handlers nil "Add Tramp file name handlers to `file-name-handler-alist' during autoload." (add-to-list 'file-name-handler-alist (cons tramp-file-name-regexp 'tramp-autoload-file-name-handler)) (put 'tramp-autoload-file-name-handler 'safe-magic t) (add-to-list 'file-name-handler-alist (cons tramp-completion-file-name-regexp 'tramp-completion-file-name-handler)) (put 'tramp-completion-file-name-handler 'safe-magic t)))

(tramp-register-autoload-file-name-handlers)

(autoload 'tramp-unload-file-name-handlers "tramp" nil nil nil)

(autoload 'tramp-completion-handle-file-name-all-completions "tramp" "\
Like `file-name-all-completions' for partial Tramp files." nil nil)

(autoload 'tramp-completion-handle-file-name-completion "tramp" "\
Like `file-name-completion' for Tramp files." nil nil)

(autoload 'tramp-unload-tramp "tramp" "\
Discard Tramp from loading remote files." t nil)

;;;***

(provide 'tramp-autoloads)
