
/*
	Tcl grammar for Antlr
	few lines was generated by AntlrWorks creator
	
	http://www.tcl.tk/man/tcl8.5/TclCmd/Tcl.htm
*/

lexer grammar Tcl;

options {	
	backtrack=true;
}

@header {
package org.netbeans.modules.languages.tcl.syntaxhilight;
}

@members{

	private Token lastEmitedToken;

	@Override
    public void emit(Token token) {
       // if(token.getChannel() == Token.DEFAULT_CHANNEL) {
            lastEmitedToken = token;
       //}
       //System.out.println("Emited token: "+token.getType() + " - " + token.getText());
        super.emit(token);
    }

    private boolean isLastToken(int... type) {
        Token last = getLastEmitedToken();
        if(last == null)
            return false;
        for(int t : type) {
            if(t == last.getType()) {
                return true;
	    }
        }
        return false;
    }

/*    private boolean isLastToken(String... type) {
        Token last = getLastEmitedToken();
        if(last == null)
            return false;
        for(String t : type) {
            if(t.equals(last.getText()))
                return true;
        }
        return false;
    }*/

    private Token getLastEmitedToken() {
        return lastEmitedToken;
    }

}


VARIABLE  
	:	'$'('a'..'z'|'A'..'Z'|'0'..'9'|'_'|'::')+
	|	'${'('a'..'z'|'A'..'Z'|'0'..'9'|'_')+'}'
	|	'$'('a'..'z'|'A'..'Z'|'0'..'9'|'_')+'(' INT ')'
    ;
    

    

INT :	('0'..'9')+
   ;

FLOAT
    :   ('0'..'9')+ '.' ('0'..'9')* EXPONENT?
    |   '.' ('0'..'9')+ EXPONENT?
    |   ('0'..'9')+ EXPONENT
    ;



// Hax to hilight variables within strings
STRING
  //  :  '\"' ( ESC_SEQ | ~('\"') )* ('\"'| VARIABLE |'[') |
  //  ('\"'|VARIABLE|']') ( ESC_SEQ | ~('\"') )* '\"'
  	: '\"' ( ESC_SEQ | ~('\"') )* ('\"')
    ;


EXPONENT : ('e'|'E') ('+'|'-')? ('0'..'9')+ ;


HEX_NUMBER 
	:	'0x' HEX_DIGIT+;

HEX_DIGIT : ('0'..'9'|'a'..'f'|'A'..'F') ;



ESC_SEQ
    :   '\\' ('a'|'b'|'t'|'n'|'f'|'r'|'\"'|'\''|'\\')
    |   UNICODE_ESC
    |   OCTAL_ESC
    |	HEX_ESC
    ;
fragment
OCTAL_ESC
    :   '\\' ('0'..'3') ('0'..'7') ('0'..'7')
    |   '\\' ('0'..'7') ('0'..'7')
    |   '\\' ('0'..'7')
    ;
fragment
UNICODE_ESC
    :   '\\' 'u' HEX_DIGIT HEX_DIGIT HEX_DIGIT HEX_DIGIT
    ;
fragment
HEX_ESC
    :   '\\' 'x' HEX_DIGIT HEX_DIGIT
    ;
    
    


// Tcl Commands: (http://www.tcl.tk/man/tcl8.5/TclCmd/contents.htm)

TCL_COMMAND
	: 'after'
	| 'append'
	| 'apply'
	| 'array'
	| 'auto_execok'
	| 'auto_import'
	| 'auto_load'
	| 'auto_mkindex'
	| 'auto_mkindex_old'
	| 'auto_qualify'
	| 'auto_reset'
	| 'Base'
	| 'bgerror'
	| 'binary'
	| 'break'
	| 'catch'
	| 'cd'
	| 'chan'
	| 'clock'
	| 'close'
	| 'concat'
	| 'continue'
	| 'dde'
	| 'dict'
	| 'encoding'
	| 'eof'
	| 'error'
	| 'eval'
	| 'exec'
	| 'exit'
	| 'expr'
	| 'fblocked'
	| 'fconfigure'
	| 'fcopy'
	| 'file'
	| 'fileevent'
	| 'filename'
	| 'flush'
	| 'for'
	| 'foreach'
	| 'format'
	| 'gets'
	| 'glob'
	| 'global'
	| 'history'
	| 'http'
	| 'if'
	| 'incr'
	| 'info'
	| 'interp'
	| 'join'
	| 'lappend'
	| 'lassign'
	| 'lindex'
	| 'linsert'
	| 'list'
	| 'llength'
	| 'load'
	| 'lrange'
	| 'lrepeat'
	| 'lreplace'
	| 'lreverse'
	| 'lsearch'
	| 'lset'
	| 'lsort'
	| 'mathfunc'
	| 'mathop'
	| 'memory'
	| 'msgcat'
	| 'namespace'
	| 'open'
	| 'package'
	| 'parray'
	| 'pid'
	| 'pkg::create'
	| 'pkg_mkIndex'
	| 'platform'
	| 'platform::shell'
	| 'proc'
	| 'puts'
	| 'pwd'
	| 'read'
	| 'refchan'
	| 'regexp'
	| 'registry'
	| 'regsub'
	| 'rename'
	| 're_syntax'
	| 'return'
	| 'Safe'
	| 'scan'
	| 'seek'
	| 'set'
	| 'socket'
	| 'source'
	| 'split'
	| 'string'
	| 'subst'
	| 'switch'
	| 'Tcl'
	| 'tcl_endOfWord'
	| 'tcl_findLibrary'
	| 'tcl_startOfNextWord'
	| 'tcl_startOfPreviousWord'
	| 'tcltest'
	| 'tclvars'
	| 'tcl_wordBreakAfter'
	| 'tcl_wordBreakBefore'
	| 'tell'
	| 'time'
	| 'tm'
	| 'trace'
	| 'unknown'
	| 'unload'
	| 'unset'
	| 'update'
	| 'uplevel'
	| 'upvar'
	| 'variable'
	| 'vwait'
	| 'while'
	;



// Tk Commands: (http://www.tcl.tk/man/tcl8.5/TkCmd/contents.htm)

TK_COMMAND
	: 'bell'
	| 'bind'
	| 'bindtags'
	| 'bitmap'
	| 'button'
	| 'canvas'
	| 'checkbutton'
	| 'clipboard'
	| 'colors'
	| 'combobox'
	| 'console'
	| 'cursors'
	| 'destroy'
	| 'done'
	| 'entry'
	| 'event'
	| 'focus'
	| 'font'
	| 'frame'
	| 'grab'
	| 'grid'
	| 'image'
	| 'intro'
	| 'keysyms'
	| 'label'
	| 'labelframe'
	| 'listbox'
	| 'loadTk'
	| 'lower'
	| 'menu'
	| 'menubutton'
	| 'message'
	| 'notebook'
	| 'option'
	| 'options'
	| 'pack'
	| 'panedwindow'
	| 'photo'
	| 'place'
	| 'progressbar'
	| 'radiobutton'
	| 'raise'
	| 'scale'
	| 'scrollbar'
	| 'selection'
	| 'send'
	| 'separator'
	| 'sizegrip'
	| 'spinbox'
	| 'style'
	| 'text'
	| 'tk'
	| 'tk_bisque'
	| 'tk_chooseColor'
	| 'tk_chooseDirectory'
	| 'tk_dialog'
	| 'tkerror'
	| 'tk_focusFollowsMouse'
	| 'tk_focusNext'
	| 'tk_focusPrev'
	| 'tk_getOpenFile'
	| 'tk_getSaveFile'
	| 'tk_menuSetFocus'
	| 'tk_messageBox'
	| 'tk_optionMenu'
	| 'tk_popup'
	| 'tk_setPalette'
	| 'tk_textCopy'
	| 'tk_textCut'
	| 'tk_textPaste'
	| 'tkvars'
	| 'tkwait'
	| 'toplevel'
	| 'treeview'
	| 'ttk_image'
	| 'ttk_vsapi'
	| 'widget'
	| 'winfo'
	| 'wm'
	;


// itcl and itclng Commands (http://wiki.tcl.tk/351 and http://wiki.tcl.tk/19873)

ITCL_COMMAND 
	: 'addcomponent'
	| 'adddelegatedmethod'
	| 'adddelegatedoption'
	| 'addobjectoption'
	| 'addoption'
	| 'body'
	| 'cget'
	| 'chain'
	| 'class'
	| 'code'
	| 'common'
	| 'component'
	| 'componentinstall'
	| 'configbody'
	| 'configure'
	| 'constructor'
	| 'createhull'
	| 'default'
	| 'delegate'
	| 'delete'
	| 'destroy'
	| 'destructor' 
	| 'ensemble'
	| 'extendedclass'
	| 'filter'
	| 'find'
	| 'forward'
	| 'hullinstall'
	| 'hulltype'
	| 'info'
	| 'inherit'
	| 'installcomponent'
	| 'is'
	| 'isa'
	| 'itcl_hull'
	| 'itcl_initoptions'
	| 'itcl_options'
	| 'keepcomponentoption'
	| 'local'
	| 'method'
	| 'methodvariable'
	| 'mixin'
	| 'mymethod'
	| 'myproc'
	| 'mytypemethod'
	| 'myvar'
	| 'option'
	| 'private'
	| 'proc'
	| 'protected'
	| 'public'
	| 'scope'
	| 'setcomponent'
	| 'setupcomponent'
	| 'type'
	| 'typeconstructor'
	| 'typemethod'
	| 'variable'
	| 'widget'
	| 'widgetadaptor'
	;
	



NAMESPACE
	:	'::' ID '::'
	|	ID '::'
	|	(WS|BRACE) '::'
	;


	
ID
	//: '#' (options {greedy=true;} : 'a'..'z'|'A'..'Z'|'0'..'9'|'_'|'#')+ WS
	: ('a'..'z'|'A'..'Z'|'0'..'9'|'_'|'#')+
//	: ('a'..'z'|'A'..'Z'|'0'..'9'|'_')+
	;

COMMENT	:
	'#' (options {greedy=false;} : .)* NEWLINE
	;

SQUOTE : '\'' { $channel = HIDDEN; } ;

BRACE
	: ')'
	| '('
	| '}'
	| '{'
	| ']'
	| '['
	;

// Operators:
OPERATOR
	:
	| '?'
	| ':'
	| '<'
	| '>'
	| '/'
	| '*'
	| '-'
	| '+'
	| '.'
	| ','
	| '='
//	| ';'
	| '!'
	| '@'
	| '#'
	| '$'
	| '%'
	| '^'
	| '&'
	| '~'
	| '|'
	| '\\'
	;

SEMICOLON
	:	';'
	;

NEWLINE:
	('\r'? '\n')+ { $channel = HIDDEN; }
	;


//	{ state.tokenStartCharPositionInLine == 0}?=> '#' ~('\n')* '\n' { $channel=HIDDEN;}
//		: { isLastToken(NEWLINE) }?=> '#' ~('\n')* '\n'
//		| { !isLastToken(NEWLINE) && input.LA(1) == OPERATOR}?=> '#' ~('\n')* '\n'
//		| { isLastToken(SEMICOLON) }?=> '#' ~('\n')* '\n'
//;
	       
WS: (' ' | '\t')+ { $channel = HIDDEN; };


	
// White Space - Commands separators
//WS///
//	: ( ' '
 //       | '\t'
//        | '\r'
//        | '\n'
        //) {$channel=HIDDEN;}
   //	;


    