/*
 * Created during Google Summer Of Code 2011.
 * For Tcl/Tk Community by student Michał Poczwardowski
 * License: BSD
 */
package org.netbeans.modules.languages.tcl.project.sample;

import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

 // Class Auto-generated by Netbeans Wizard.

/**
 * Panel just asking for basic info.
 */
public class TclEmptyProjectWizardPanel implements WizardDescriptor.Panel,
       WizardDescriptor.ValidatingPanel, WizardDescriptor.FinishablePanel {

	private WizardDescriptor wizardDescriptor;
	private TclEmptyProjectPanelVisual component;

	public TclEmptyProjectWizardPanel() {
	}

	@Override
	public Component getComponent() {
		if( component==null ) {
			component=new TclEmptyProjectPanelVisual( this );
			component.setName( NbBundle.getMessage( TclEmptyProjectWizardPanel.class, "LBL_CreateProjectStep" ) );
		}
		return component;
	}

	@Override
	public HelpCtx getHelp() {
		return new HelpCtx( TclEmptyProjectWizardPanel.class );
	}

	@Override
	public boolean isValid() {
		getComponent();
		return component.valid( wizardDescriptor );
	}

	private final Set<ChangeListener> listeners=new HashSet<ChangeListener>( 1 ); // or can use ChangeSupport in NB 6.0

	@Override
	public final void addChangeListener( ChangeListener l ) {
		synchronized( listeners ){
			listeners.add( l );
		}
	}

	@Override
	public final void removeChangeListener( ChangeListener l ) {
		synchronized( listeners ){
			listeners.remove( l );
		}
	}

	protected final void fireChangeEvent() {
		Set<ChangeListener> ls;
		synchronized( listeners ){
			ls=new HashSet<ChangeListener>( listeners );
		}
		ChangeEvent ev=new ChangeEvent( this );
		for( ChangeListener l:ls ) {
			l.stateChanged( ev );
		}
	}

	@Override
	public void readSettings( Object settings ) {
		wizardDescriptor=( WizardDescriptor )settings;
		component.read( wizardDescriptor );
	}

	@Override
	public void storeSettings( Object settings ) {
		WizardDescriptor d=( WizardDescriptor )settings;
		component.store( d );
	}

	@Override
	public boolean isFinishPanel() {
		return true;
	}

	@Override
	public void validate() throws WizardValidationException {
		getComponent();
		component.validate( wizardDescriptor );
	}

}
