
###
##
#
#### Better multiplication command
#
##
###

proc multiply {n m} {
    set res 0
    while {$n > 0} {
	if {($n % 2) == 1} {
	    incr n -1
	    incr res $m
	} else {
	    set n [expr {$n/2}]
	    incr m $m
	}
    }
    return $res
}

##
## Time the multiply command with various arguments.
##

proc tfmt {tres} {
    set time [lindex $tres 0]
    set text [join [lrange $tres 1 end]]
    set time [format {% 6d} $time]
    return "$time $text"
}

puts "time (    2 x  3) = [tfmt [time {multiply     2  3} 10]]"
puts "time (    5 x  2) = [tfmt [time {multiply     5  2} 10]]"
puts "time ( 5000 x 20) = [tfmt [time {multiply  5000 20} 10]]"
puts "time (10000 x 10) = [tfmt [time {multiply 10000 10} 10]]"

exit
