
##
## Load the tcltest package required by the testsuite, provide a
## special function possible required by the testsuite we are loading,
## and _reconfigure tcltest_ to run the tests in the same process as
## this script. Without the reconfiguration this script will launch a
## subprocess for the testing to be done in, thus taking out of the
## reach of the debugger, defeating our purpose.
##

package require  tcltest
namespace import ::tcltest::*

proc ::tcltest::getErrorMessage {
    functionName argList missingIndex
} {
    # if oldstyle errors:
    if { [info tclversion] < 8.4 } {
	set msg "no value given for parameter "
	append msg "\"[lindex $argList $missingIndex]\" to "
	append msg "\"$functionName\""
    } else {
	set msg "wrong # args: should be \"$functionName $argList\""
    }
    return $msg
}

set ::tcltest::testSingleFile false
set ::tcltest::testsDirectory [file dirname [info script]]
set root                      $::tcltest::testsDirectory

##
## Load the code we do the coverage analysis for, then
## run the testsuite for that code.

source [file join $root csv.tcl]
source [file join $root csv.test]

##
## cleanup after the tcltest package
##

::tcltest::cleanupTests 1
exit

