# ==========================================
# The package we want to load.

# ==========================================

set information [list]
lappend information {Loaded packages}

catch {package require __bad__}
foreach p [package names] {
    catch {lappend information "*\t$p\t[package present $p]"}
}

lappend information {Loaded libraries}
foreach lib [info loaded] {
    foreach {path id} $lib break
    lappend information "-\t$id\t($path)"
}

package require Tk

wm title . Information

text   .t -relief sunken -width 100 -height 50
button .e -command exit -text Ok

.t insert end [join $information \n]

pack   .t
pack   .e -pady 1m

vwait __forever__
exit

