'\"
'\" Generated from file '../../src/doc/img-raw.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 1995-2009 Jan Nijtmans <nijtmans@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "img-raw" n 1.4 img-raw "Img"
.BS
.SH NAME
img-raw \- Img, Raw Data Format (raw)
.SH SYNOPSIS
package require \fBTk \fR
.sp
package require \fBimg::raw  ?1.4?\fR
.sp
\fBimage\fR \fBcreate photo\fR ?\fIname\fR? ?\fIoptions\fR?
.sp
.BE
.SH DESCRIPTION
The package \fBimg::raw\fR is a sub-package of
\fBImg\fR. It can be loaded as a part of the complete Img support,
via \fBpackage require Img\fR, or on its own, via
\fBpackage require img::raw\fR.
.PP
Like all packages of \fBImg\fR it does \fInot\fR provide new
commands, but extends the existing \fBTk\fR command \fBimage\fR so
that it supports files containing raster images in the
Raw Data Format (raw). More specifically
\fBimg::raw\fR extends \fBTk\fR's \fBphoto\fR
image type.
.PP
The name of the new format handler is \fBraw\fR.
This handler provides new additional configuration options. See
section \fBRAW OPTIONS\fR for more detailed explanations.
.PP
All of the above means that in a call like
.TP
\fBimage\fR \fBcreate photo\fR ?\fIname\fR? ?\fIoptions\fR?
.PP
.IP [1]
Image data in raw format (options \fB-data\fR and \fB-file\fR) is
detected automatically.
.IP [2]
The format name \fBraw\fR is recognized by the option \fB-format\fR.
In addition the value for the option is treated as list and may
contain any of the special options listed in section
\fBRAW OPTIONS\fR.
.PP
.SH NOTE
This format handler must be loaded explicitly with
\fBpackage require img::raw\fR.
.SH "SUPPORTED RAW TYPES"
.CS

 Grayscale image:  1 channel  of 32-bit floating point   values.
                   1 channel  of 16-bit unsigned integer values.
                   1 channel  of  8-bit unsigned integer values.
 True-color image: 3 channels of 32-bit floating point   values.
                   3 channels of 16-bit unsigned integer values.
                   3 channels of  8-bit unsigned integer values.

 List of currently supported features:

 Type   |     Read      |     Write     |
        | -file | -data | -file | -data |
 ----------------------------------------
 Gray   | Yes   | Yes   | Yes   | Yes   |
 RGB    | Yes   | Yes   | Yes   | Yes   |

 There are 2 supported file formats:
 One with the pure raw data only, the other with a 7 line ASCII header
 of the following form:

     Magic=RAW\\n          File format identifier. Fixed value.
     Width=128\\n          Image width in pixels.
     Height=128\\n         Image height in pixels.
     NumChan=1\\n          Possible values: 1 or 3.
     ByteOrder=Intel\\n    Possible values: "Intel" or "Motorola".
     ScanOrder=TopDown\\n  Possible values: "TopDown" or "BottomUp".
     PixelType=byte\\n     Possible values: "float", "short" or "byte".


.CE
.SH "RAW OPTIONS"
The handler provides the following options:
.TP
\fB-verbose\fR \fIbool\fR
This option is supported for reading and writing.
.sp
If set to \fBtrue\fR, additional information about the loaded/stored image
is printed to stdout. Default is \fBfalse\fR.
.TP
\fB-useheader\fR \fIbool\fR
This option is supported for reading and writing.
.sp
If set to \fBtrue\fR, use the file header information for reading and writing.
Default is \fBtrue\fR.
.TP
\fB-nchan\fR \fIint\fR
This option is supported for reading and writing image data without header.
.sp
Specify the number of channels of the input image.
Default is \fB1\fR.
.TP
\fB-width\fR \fIint\fR
This option is supported for reading image data without header only.
.sp
Specify the width of the input image.
Default is \fB128\fR.
.TP
\fB-height\fR \fIint\fR
This option is supported for reading image data without header only.
.sp
Specify the height of the input image.
Default is \fB128\fR.
.TP
\fB-byteorder\fR \fIstring\fR
This option is supported for reading image data without header only.
.sp
Specify the byteorder of the input image data.
Possible values: \fBIntel\fR or \fBMotorola\fR.
Default is assuming the same byteorder as that of the host computer.
.TP
\fB-uuencode\fR \fIbool\fR
This option is supported for reading image data without header only.
.sp
If set to \fBfalse\fR, do not assume, that the image data stored in a
Tcl variable is uuencoded. Default is \fBtrue\fR, i.e. the image data in
a Tcl variable is assumed to be uuencoded.
.TP
\fB-scanorder\fR \fIstring\fR
This option is supported for reading and writing image data without header.
.sp
Specify the scanline order of the input image.
Possible values: \fBTopDown\fR or \fBBottomUp\fR.
Default is assuming the same byteorder as that of the host computer.
.TP
\fB-pixeltype\fR \fIstring\fR
This option is supported for reading image data without header only.
.sp
Specify the type of the pixel values.
Possible values: \fBfloat\fR or \fBshort\fR or \fBbyte\fR.
Default is \fBbyte\fR.
.sp
RAW files are always written in \fBbyte\fR pixel format.
.TP
\fB-gamma\fR \fIfloat\fR
This option is supported for reading only.
.sp
Specify a gamma correction to be applied when mapping
the input data to 8-bit image values.
Default is \fB1.0\fR.
.TP
\fB-nomap\fR \fIbool\fR
This option is supported for reading only.
.sp
If set to \fBtrue\fR, no mapping of input values is done.
Use this option, if your image already contains RGB
values in the range of \fB0\fR .. \fB255\fR.
When using the nomap mode, no information about the
minimum and maximum pixel values is gathered during
reading and therefore no verbose output is printed.
On the other hand reading the image is faster.
Default is \fBfalse\fR.
.TP
\fB-min\fR \fIfloat\fR
This option is supported for reading only.
.sp
Specify the minimum pixel value to be used for mapping
the input data to 8-bit image values.
Default is the minimum value found in the image data.
.TP
\fB-max\fR \fIfloat\fR
This option is supported for reading only.
.sp
Specify the maximum pixel value to be used for mapping
the input data to 8-bit image values.
Default is the maximum value found in the image data.
.PP
.PP
.SH "SEE ALSO"
img-bmp, img-dted, img-gif, img-ico, img-intro, img-jpeg, img-pcx, img-pixmap, img-png, img-ppm, img-ps, img-raw, img-sgi, img-sun, img-tga, img-tiff, img-window, img-xbm, img-xpm
.SH KEYWORDS
image handling, raw, tk
.SH COPYRIGHT
.nf
Copyright (c) 1995-2009 Jan Nijtmans <nijtmans@users.sourceforge.net>

.fi