'\"
'\" Generated from file 'canvas_epoints\&.man' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "canvas::edit::points" n 0\&.1 tklib "Variations on a canvas"
.BS
.SH NAME
canvas::edit::points \- Editing a cloud of points on a canvas
.SH SYNOPSIS
package require \fBTcl  8\&.5\fR
.sp
package require \fBTk  8\&.5\fR
.sp
package require \fBcanvas::edit::points  ?0\&.1?\fR
.sp
\fB::canvas::edit\fR \fBpoints\fR \fIobjectName\fR \fIcanvas\fR \fIoptions\fR\&.\&.\&.
.sp
\fBobjectName\fR \fBdestroy\fR
.sp
\fBobjectName\fR \fBenable\fR
.sp
\fBobjectName\fR \fBdisable\fR
.sp
\fBobjectName\fR \fBactive\fR
.sp
\fBobjectName\fR \fBadd\fR \fIx\fR \fIy\fR
.sp
\fBobjectName\fR \fBclear\fR
.sp
\fBcreateCmd\fR \fIcanvas\fR \fIx\fR \fIy\fR
.sp
\fBhighlightCmd\fR \fBon\fR \fIcanvas\fR \fIitem\fR
.sp
\fBhighlightCmd\fR \fBoff\fR \fIcanvas\fR \fIstate\fR
.sp
\fBdataCmd\fR \fBadd\fR \fIeditorObj\fR \fIid\fR \fIx\fR \fIy\fR
.sp
\fBdataCmd\fR \fBremove\fR \fIeditorObj\fR \fIid\fR
.sp
\fBdataCmd\fR \fBmove start\fR \fIeditorObj\fR \fIid\fR
.sp
\fBdataCmd\fR \fBmove delta\fR \fIeditorObj\fR \fIid\fR \fIx\fR \fIy\fR \fIdx\fR \fIdy\fR
.sp
\fBdataCmd\fR \fBmove done\fR \fIeditorObj\fR \fIid\fR
.sp
.BE
.SH DESCRIPTION
This package provides a class whose instances handle editing a cloud
of point markers on a canvas\&. Instances can be configured with regard
to the visual appearance of markers (regular, and highlighted)\&. Note
that instances do not store the edited points themselves, but delegate
this to a configurable object\&.
.SH "CLASS API"
.TP
\fB::canvas::edit\fR \fBpoints\fR \fIobjectName\fR \fIcanvas\fR \fIoptions\fR\&.\&.\&.
This, the class command, creates and configures a new instance of a
point cloud editor, named \fIobjectName\fR\&. The instance will be
connected to the specified \fIcanvas\fR widget\&.
.sp
The result of the command is the fully qualified name of the
instance command\&.
.sp
The options accepted here, and their values, are explained in
the section \fBOptions\fR\&.
.PP
.SH "INSTANCE API"
Instances of the point cloud editors provide the following API:
.TP
\fBobjectName\fR \fBdestroy\fR
This method destroys the point cloud editor and releases all its
internal resources\&.
.sp
Note that this operation does not destroy the items of the
point markers the editor managed on the attached canvas, nor the
canvas itself\&.
.sp
The result of the method is an empty string\&.
.TP
\fBobjectName\fR \fBenable\fR
This method activates editing of the point cloud on the canvas\&. This
is the default after instance creation\&. A call is ignored if the
editor is already active\&.
.sp
The result of the method is an empty string\&.
.sp
The complementary method is \fBdisable\fR\&. The interogatory
method for the current state is \fBactive\fR\&.
.TP
\fBobjectName\fR \fBdisable\fR
This method disables editing of the point cloud on the canvas\&. A call
is ignored if the editor is already disabled\&.
.sp
The result of the method is an empty string\&.
.sp
The complementary method is \fBenable\fR\&. The interogatory
method for the current state is \fBactive\fR\&.
.TP
\fBobjectName\fR \fBactive\fR
This method queries the editor state\&.
.sp
The result of the method is a boolean value, \fBtrue\fR if
the editor is active, and \fBfalse\fR otherwise, i\&.e\&. disabled\&.
.sp
The methods to change the state are \fBenable\fR and
\fBdisable\fR\&.
.TP
\fBobjectName\fR \fBadd\fR \fIx\fR \fIy\fR
This method programmatically creates a point at the specified location\&.
.sp
The result of the method is an empty string\&.
.sp
Note that this method goes through the whole set of callbacks
invoked when the user interactively creates a point, i\&.e\&.
\fB-create-cmd\fR, and, more importantly, \fB-data-cmd\fR\&.
.sp
This is the method through which to load pre-existing points
into an editor instance\&.
.TP
\fBobjectName\fR \fBclear\fR
This method programmatically removes all points from the editor\&.
.sp
The result of the method is an empty string\&.
.sp
Note that this method goes through the same callback invoked
when the user interactively removes a point, i\&.e\&. \fB-data-cmd\fR\&.
.PP
.SH OPTIONS
The class command accepts the following options
.TP
\fB-tag\fR \fIstring\fR
The value of this option is the name of the canvas tag with which to
identify all items of all points managed by the editor\&.
.sp
This option can only be set at construction time\&.
.sp
If not specified it defaults to \fBPOINT\fR
.TP
\fB-create-cmd\fR \fIcommand-prefix\fR
The value of this option is a command prefix the editor will invoke
when it has to create a new point\&.
.sp
This option can only be set at construction time\&.
.sp
If not specified it defaults to a command which will create a
black-bordered blue circle of radius 3 centered on the location of the
new point\&.
.sp
The signature of this command prefix is
.RS
.TP
\fBcreateCmd\fR \fIcanvas\fR \fIx\fR \fIy\fR
The result of the command prefix \fImust\fR be a list of the canvas
items it created to represent the marker\&. Note here that the visual
representation of a "point" may consist of multiple canvas items in an
arbitrary shape\&.
.sp
The returned list of items is allowed to be empty, and such is
taken as signal that the callback vetoed the creation of the point\&.
.RE
.TP
\fB-highlight-cmd\fR \fIcommand-prefix\fR
The value of this option is a command prefix the editor will invoke
when it has to (un)highlight a point\&.
.sp
This option can only be set at construction time\&.
.sp
If not specified it defaults to a command which will re-color
the item to highlight in red (and restores the color for
unhighlighting)\&.
.sp
The two signatures of this command prefix are
.RS
.TP
\fBhighlightCmd\fR \fBon\fR \fIcanvas\fR \fIitem\fR
.sp
This method of the command prefix has to perform whatever is
needed to highlight the point the \fIitem\fR is a part of (remember
the note above about points allowed to be constructed from multiple
canvas items)\&.
.sp
The result of the command can be anything and will be passed as
is as argument \fIstate\fR to the \fBoff\fR method\&.
.TP
\fBhighlightCmd\fR \fBoff\fR \fIcanvas\fR \fIstate\fR
.sp
This method is invoked to unhighlight a point described by the
\fIstate\fR, which is the unchanged result of the \fBon\fR method
of the command prefix\&. The result of this method is ignored\&.
.sp
Note any interaction between dragging and highlighting of
points is handled within the editor, and that the callback bears no
responsibility for doing such\&.
.RE
.TP
\fB-data-cmd\fR \fIcommand-prefix\fR
The value of this option is a command prefix the editor will invoke
when a point was edited in some way\&. This is how the editor delegates
the actual storage of point information to an outside object\&.
.sp
This option can only be set at construction time\&.
.sp
If not specified it defaults to an empty string and is ignored
by the editor, i\&.e\&. not invoked\&.
.sp
The signatures of this command prefix are
.RS
.TP
\fBdataCmd\fR \fBadd\fR \fIeditorObj\fR \fIid\fR \fIx\fR \fIy\fR
This callback is invoked when a new point was added to the instance,
either interactively, or programmatically\&.
See instance method \fBadd\fR for the latter\&.
.sp
The \fIid\fR identifies the point within the editor and will be
used by the two other callbacks to specify which point to modify\&.
.sp
The last two arguments \fIx\fR and \fIy\fR specify the location
of the new point in canvas coordinates\&.
.sp
The result of this method is ignored\&.
.TP
\fBdataCmd\fR \fBremove\fR \fIeditorObj\fR \fIid\fR
This callback is invoked when a point removed from the editor
instance\&.
.sp
The \fIid\fR identifies the removed point within the editor\&.
.sp
The result of this method is ignored\&.
.TP
\fBdataCmd\fR \fBmove start\fR \fIeditorObj\fR \fIid\fR
This callback is invoked when the movement of a point in the editor
instance has started\&.
.sp
The \fIid\fR identifies the point within the editor about to be
moved\&.
.sp
The result of this method is ignored\&.
.TP
\fBdataCmd\fR \fBmove delta\fR \fIeditorObj\fR \fIid\fR \fIx\fR \fIy\fR \fIdx\fR \fIdy\fR
This callback is invoked when the point moved in the editor instance\&.
.sp
The \fIid\fR identifies the moved point within the editor, and
the remaining arguments \fIx\fR, \fIy\fR, \fIdx\fR, and \fIdy\fR
provide the new absolute location of the point, and full delta to the
original location\&.
.sp
At the time of the calls the system is \fInot\fR committed to
the move yet\&. Only after method \fBmove done\fR was invoked and
has accepted or rejected the last position will the editor update its
internal data structures, either committing to the new location, or
rolling the move back to the original one\&.
.sp
Given this the location data provided here should be saved only
in temporary storage until then\&.
.sp
The result of this method is ignored\&.
.TP
\fBdataCmd\fR \fBmove done\fR \fIeditorObj\fR \fIid\fR
This callback is invoked when the movement of a point in the editor
instance is complete\&.
.sp
The \fIid\fR identifies the moved point within the editor\&.
.sp
The result of this method must be a boolean value\&. If the
method returns \fBfalse\fR the move is vetoed and rollbed back\&.
.RE
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIcanvas\fR of the
\fITklib Trackers\fR [http://core\&.tcl\&.tk/tklib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.SH KEYWORDS
canvas, editing, point cloud, points