#      tQL - relational database interface
#      Copyright (C) 1999 Timothy Fisken (tim@rose-cottage.demon.co.uk)
#     
#      This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 1, or (at your option)
#      any later version.
 #    
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
#     
#      You should have received a copy of the GNU General Public License
#      along with this program; if not, write to the Free Software
#      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# All functions are in the tQL namespace

package provide tQL 0.1

namespace eval tQL {

# Dummy procs for auto_mkindex
proc ::tQL::Init {} {}
proc ::tQL::Exec {} {}
proc ::tQL::Rows {} {}
proc ::tQL::Fields {} {}
proc ::tQL::Fieldname {} {}
proc ::tQL::Value {} {}
proc ::tQL::Status {} {}
proc ::tQL::Tabulate {} {}
proc ::tQL::Query {} {}
    
    # Notify the user that the tQL system has not been initialised
    proc notinited { context } {
	error "tQL must be initaliesed with tQL::Init" "tQL not initialised in \"tQL::$context\""
    }

    # A utility function to make use of the 'array get' lists returned by queries
    proc aref { list index } {
	array set ar $list
	return $ar($index)
    }

    proc Init { dbtype { namespace ::tQL } } {
	set head "::"
	set tail "::Init"
	package require $dbtype
	$head$dbtype$tail $namespace
    }
    
    # The functions below should be replaced by specific functions to access the database

    # Open a database. At least the following arguments should be supported
    # -db name, -host name, -port number. Others can be added as well, if you like.
    proc OpenDB { args } {
	notinited OpenDB
    }
    
    # Execute a SQL query, returning an object representing an internal result
    # structure.
    proc Exec { db query } {
	notinited Exec
    }

    # The following functions extract information from a result table (returned from exec)
    # Number of rows
    proc Rows { result } {
	notinited Rows
    }
    # Number of fields
    proc Fields { result } {
	notinited Fields
    }
    # The name of a given field
    proc Fieldname { result number } {
	notinited Fieldname
    }
    # Retrieves a value from the table
    proc Value { result row field } {
	notinited Value
    }
   # Retrieves the status of a command result
   proc Status { result } {
       notinited Status
   }

    # End of function stubbs - the following functions should not
    # (normally) be replaced

    # Converts a results table to a tcl hash
    proc Tabulate { result } {
	set nrows [Rows $result]
	set nfields [Fields $result]
	set ret(result) $result
	set ret(status) [Status $result]
	
	for { set i 0 } { $i < $nrows } { incr i } {
	    for { set j 0 } { $j < $nfields } {incr j } {
		set name [Fieldname $result $j]
		set ret($i,$name) [Value $result $i $j]
	    }
	}
	array get ret
    }

    # Creates a proc that will execute the specified query and return a
    # tcl hash
    proc Query { name args query } {
	uplevel [list proc $name [concat db $args] "tQL::Tabulate \[tQL::Exec \$db \"$query\"\]"]
    }

    # Export all the user-level functions
    namespace export Init Exec Rows Fields Fieldname Value  Status Tabulate Query
}
