#      tQL - relational database interface
#      Copyright (C) 1999 Timothy Fisken (tim@rose-cottage.demon.co.uk)
#     
#      This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 1, or (at your option)
#      any later version.
 #    
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
#     
#      You should have received a copy of the GNU General Public License
#      along with this program; if not, write to the Free Software
#      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# PGtQL - TCL interface file.
# Manages the PGtQL namespace, and takes care of loading in the shared
# library.

# Ensure that the namespace exists before the shared lib is loaded.
namespace eval Postgres {
    proc Init { ns } {
	namespace eval $ns {
	    namespace import -force ::Postgres::*
	}
    }
    
    # These are the user visible commands, to be exported
    namespace export OpenDB Exec Rows Fields Fieldname Value Status Init
}

load libpgtql.so

package provide Postgres 0.1
		    