.\"
.\" tclXtSend: Tk's send primitive for Xt
.\"
.\" Jan Newmarch, jan@pandonia.ise.edu.au, 16 Oct 1992.
.\"
.TH tclXtSend 3 "16 Oct 1993"
.SH NAME
tclXtSend \- the Tk "send" protocol for Xt
.SH SYNOPSIS
.na
.in +8n
.ti -8n
.I int TclXtSend_RegisterInterp(interp, name, toplevel)
    Tcl_Interp *interp;
    char *name;
    Widget toplevel;
.in -8n
.ad
.SH DESCRIPTION
.PP
This registers an interpreter using the name
.I name.
The name must be unique to the server.
It takes a tcl interpreter and a toplevel widget as additional arguments.
This creates two commands within the interpreter, 
.I send
and 
.I interps.
.PP
The
.I send
command behaves like the send command for Tk: given an interpreter name
and a command, it executes the command in that interpreter.
The interpreter for the command may be the current interpreter.
.PP
The
.I interps 
command returns a list of interpreters currently known to the server.

.SH "RETURN VALUE"
If the command succeeds in registering the interpreter under the name,
it returns TCL_OK. Otherwise it returns TCL_ERROR. A string containing
error information will be stored in
.I interp->result.

.SH "SEE ALSO"
.PP
See the book on Tcl/Tk by John Ousterhout, or the Tk doco for "send".
.SH AUTHOR
.PP
Jan Newmarch, University of Canberra
.br
(jan@ise.canberra.edu.au)

.SH BUGS
The -displayof option is not implemented.

