/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 * All rights reserved.
 *
 * You can use and distribute this software under the terms of the license
 * you should have received along with this software; either version 1.1 of
 * the license, or (at your option) any later version.
 * For a copy of the license or for additional information about this software,
 * write to Xcc Software, Durlacher Allee 53, D-76131 Karlsruhe, Germany;
 * Email: obst@xcc-ka.de.
 * --------------------------------------------------------------------------
 * Simple class for measuring and processing times.
 * --------------------------------------------------------------------------
 * ORIGINAL: D. Theobald				DATE: 14/2/93
 * --------------------------------------------------------------------------
 */

#define _FSIG_(x) x

#include <stdio.h>

#include "timer.h"


// --------- implementation of C++ methods ----------------------------------

Timer& Timer::operator+= (const Timer &tp)
{  	 int            *nptr    = &negative[2];
   const int            *tp_nptr = &tp.negative[2];
   	 struct timeval *tptr    = &tv[2];
   const struct timeval *tp_tptr = &tp.tv[2];
   do
   {  if (*nptr == *tp_nptr)
      {  tptr->tv_sec += tp_tptr->tv_sec;

	 if ((tptr->tv_usec += tp_tptr->tv_usec) >= 1000000)
	 {  ++ tptr->tv_sec;
	    tptr->tv_usec -= 1000000;
	 }
      }
      else if ((tptr->tv_usec -= tp_tptr->tv_usec) < 0)
      {  if ((tptr->tv_sec -=  tp_tptr->tv_sec) == 0)
	 {  *nptr   	  = ! *nptr;
	    tptr->tv_usec = - tptr->tv_usec;
	 }
	 else if (tptr->tv_sec < 0)
	 {  *nptr   	  = ! *nptr;
	    tptr->tv_sec  = - tptr->tv_sec;
	    tptr->tv_usec = - tptr->tv_usec;
	 }
	 else
	 {  -- tptr->tv_sec;
	    tptr->tv_usec += 1000000;
	 }
      }
      else if ((tptr->tv_sec -=  tp_tptr->tv_sec) < 0)
      {  tptr->tv_sec = -tptr->tv_sec - 1;
	 *nptr        = ! *nptr;
      }
      -- tptr; -- tp_tptr; -- tp_nptr;
   }
   while (-- nptr >= negative);

#ifdef TIMER_PROCRESOURCES
   blocks_in  += tp.blocks_in;
   blocks_out += tp.blocks_out;
#endif

   return *this;
}

ostream& Timer::print (ostream &o, time_kind k /*= TP_WALLCLOCK*/) const
{  return o << (negative[k] ? "-" : "")
	    << tv[k].tv_sec
	    << form (".%06lds", tv[k].tv_usec);
}

ostream& operator<< (ostream &o, const Timer &tp)
{  tp.print (o << "[elapsed:", TP_WALLCLOCK);
   tp.print (o << "|user:",    TP_USER);
   tp.print (o << "|system:",  TP_SYSTEM);

#ifdef TIMER_PROCRESOURCES
   o << "|blocks in:"  << tp.blocks_in
     << "|blocks out:" << tp.blocks_out;
#endif

   return o << "]";
}

void Timer::write_duration (ostream    &o,
			    const int  runs,
			    const char *description /* ="s" */,
			    time_kind  k /* = TP_WALLCLOCK */) const
{  o << form ("%.6f%s", cvt2double(k) / (double)runs, description);
}


// --------- implementation of C accessor functions -------------------------

Timer_t tmr_new()
{  return (Timer_t)(new Timer);
}
void tmr_delete (Timer_t t)
{  delete (Timer*)t;
}

void tmr_read_timer (Timer_t t)
{  ((Timer*)t)->read_timer();
}
void tmr_write_duration (Timer_t t, int runs, char* descr, time_kind k)
{  fflush (stdout);
   ((Timer*)t)->write_duration (cout, runs, descr, k);
   cout.flush();
}
void tmr_print (Timer_t t)
{  fflush (stdout);
   cout << (*(Timer*)t);
   cout.flush();
}
void tmr_print_time (Timer_t t, time_kind k)
{  fflush (stdout);
   ((Timer*)t)->print (cout, k);
   cout.flush();
}

Timer_t tmr_assign (Timer_t t, Timer_t a_t)
{  (*(Timer*)t) = (*(Timer*)a_t);
   return t;
}
Timer_t tmr_negate (Timer_t t)
{  Timer *res = new Timer;  *res = - (*(Timer*)t);
   return (Timer_t)res;
}
Timer_t tmr_add (Timer_t t, Timer_t a_t)
{  Timer *res = new Timer;  *res = (*(Timer*)t) + (*(Timer*)a_t);
   return (Timer_t)res;
}
Timer_t tmr_sub (Timer_t t, Timer_t a_t)
{  Timer *res = new Timer;  *res = (*(Timer*)t) - (*(Timer*)a_t);
   return (Timer_t)res;
}
Timer_t tmr_add_to (Timer_t t, Timer_t a_t)
{  (*(Timer*)t) += (*(Timer*)a_t);
   return t;
}
Timer_t tmr_sub_from (Timer_t t, Timer_t a_t)
{  (*(Timer*)t) -= (*(Timer*)a_t);
   return t;
}
double tmr_2double (Timer_t t, time_kind k)
{  return ((Timer*)t)->cvt2double (k);
}
