/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 * All rights reserved.
 *
 * You can use and distribute this software under the terms of the license
 * you should have received along with this software; either version 1.1 of
 * the license, or (at your option) any later version.
 * For a copy of the license or for additional information about this software,
 * write to Xcc Software, Durlacher Allee 53, D-76131 Karlsruhe, Germany;
 * Email: obst@xcc-ka.de.
 * --------------------------------------------------------------------------
 * Simple test program for the use of the binary tree routines from the
 * C library (tsearch, tfind, ...).
 * --------------------------------------------------------------------------
 */
#define OBST_IMP_SORT_SEARCH
#define OBST_IMP_STRINGOP
#define OBST_IMP_FORMATTED_IO
#include "obst_stdinc.h"

extern "C" {
   typedef void walkproc(char* node, VISIT v, int level);
 
   char* tfind   (char* key, char** rootp, qsort_cmpfct_t* fct);
   void  twalk   (char* rootp, walkproc* action);
}

// --------------------------------------------------------------------------
// (Hide the complexity of using a char* as the tree node type by means of
//  the following abstraction.)

#define USE_EXPLICIT_NODE 0
#define USE_PROC_FROM_LIB 1

#if USE_EXPLICIT_NODE
   struct tnode { char* str; };

   inline char* node2str(tnode* nptr) 	         { return nptr->str; }
   inline void  set_str (tnode* nptr, char* str) { nptr->str = str; }
#else
   typedef char* tnode;

   inline char* node2str(tnode* nptr)            { return *nptr; }
   inline void  set_str (tnode* nptr, char* str) { *nptr = str; }
#endif

// --------------------------------------------------------------------------

tnode* tree_root = NULL;

int strcmpfct (tnode* n1ptr, tnode* n2ptr)
{  /*
    printf ("strcmpfct(\"%s\", \"%s\")\n", node2str(n1ptr), node2str(n2ptr));
    */
   return strcmp(node2str(n1ptr), node2str(n2ptr));
}

#if USE_PROC_FROM_LIB && !USE_EXPLICIT_NODE
char* uniqueString (char* str)
{  static char** nptr = new (char*);
          char** found;

   *nptr = str;
   if (nptr == (found = *(char***)tsearch ((void*)nptr, (void**)&tree_root,
					   (qsort_cmpfct_t*)&strcmpfct)))
   {  *nptr = strdup(str);
      nptr  = new (char*);
   }
   return *found;
}

#else
char* uniqueString (char* str)
{  tnode** result;
   static tnode* nptr = new tnode;

   set_str(nptr, str);

   result = (tnode**)tsearch ((void*)nptr,
			      (void**)&tree_root, (qsort_cmpfct_t*)&strcmpfct);
   if (nptr == *result)
   {  set_str(nptr, strdup(str));
      nptr = new tnode;
   }
   printf ("uniqueString(<0x%lx>\"%s\") --> <0x%lx>\"%s\"\n",
	   str, str, node2str(*result), node2str(*result));
   
   return node2str(*result);
}
#endif

void print_node (tnode** node, VISIT v, int level)
{  char* vstr;
   switch (v)
   {  case preorder : vstr = "preorder";  break;
      case postorder: vstr = "postorder"; break;
      case endorder : vstr = "endorder";  break;
      case leaf	    : vstr = "leaf";	  break;
      default	    : vstr = "<unknown>";
   }
   if (v == postorder || v == leaf)	// lexicographical sorted output
      printf ("node(\"%s\").level(%d).mode(%s)\n",
	      node2str(*node), level, vstr);
}

int main (int argc, char* argv[])
{
   uniqueString ("Walter");  uniqueString ("Bernhard");
   uniqueString ("Michael"); uniqueString ("Jochen");
   uniqueString ("Simone");  uniqueString ("Claus");
   uniqueString ("Guenter"); uniqueString ("Eduardo");
   uniqueString ("Dietmar");

   uniqueString ("Walter");  uniqueString ("Bernhard");
   uniqueString ("Michael"); uniqueString ("Jochen");
   uniqueString ("Simone");  uniqueString ("Claus");
   uniqueString ("Guenter"); uniqueString ("Eduardo");
   uniqueString ("Dietmar");

   twalk ((char*)tree_root, &print_node);

   return 0;
}
