/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 * All rights reserved.
 *
 * You can use and distribute this software under the terms of the license
 * you should have received along with this software; either version 1.1 of
 * the license, or (at your option) any later version.
 * For a copy of the license or for additional information about this software,
 * write to Xcc Software, Durlacher Allee 53, D-76131 Karlsruhe, Germany;
 * Email: obst@xcc-ka.de.
 * --------------------------------------------------------------------------
 */
#include <stream.h>

extern "C" {
extern void test_ops_C();
extern void time_timer_C();
}

#define TIME_OBST	1
#define TEST_TIMER
#define __FSIG_(x)	x

#include "timer.h"

// --------------------------------------------------------------------------

#if TIME_OBST

#include "obst.h"
#include "knl_use.h"

void time_OBST ()
{  Timer start, end;

   sos_Container cnt = sos_Container::create();
   sos_Object    o   = sos_String::create(cnt);
   cnt.close();

   const int RUNS = 100;

   start.read_timer();
   for (int i = RUNS;  -- i; )
   {  cnt.open (WRITING, WAITING);
      cnt.close();
   }
   end.read_timer();

   cnt.open (WRITING, WAITING);
   cnt.destroy();

   cout << "\nTimed : open&&close of container holding 1 sos_Object\nResult: ";
   (end-start).write_duration (cout, RUNS);
   cout << " [s/open&&close]  (" << end-start << ", " << RUNS << " runs)\n";
}
#else
void time_OBST ()
{  cout << "\n\tnot compiled (aetsch)\n\n\n";
}
#endif TIME_OBST

// --------------------------------------------------------------------------

void time_timer ()
{  const int RUNS = 100000;

   Timer start, end, dummy;
   int	     i;

   start.read_timer();
   for (i = RUNS;  -- i; )
      ;
   end.read_timer();

   Timer pure_loop = end - start;

   start.read_timer();
   for (i = RUNS;  -- i; )
      dummy.read_timer();
   end.read_timer();

   Timer dur = end - start - pure_loop;

   dur.print (cout << "Timer call: ca. ") << " (" << RUNS << " calls)  --> ";
   dur.write_duration (cout, RUNS, " [s/call]\n");
}

// --------------------------------------------------------------------------

Timer null = { { {0,0}, {0,0}, {0,0} }, { 0, 0, 0 } },
      one  = { { {1,0}, {1,0}, {1,0} }, { 0, 0, 0 } },
      one_2= { { {1,200000}, {1,200000}, {1,200000} }, { 0, 0, 0 } },
      one_8= { { {1,800000}, {1,800000}, {1,800000} }, { 0, 0, 0 } },
      two_3= { { {2,300000}, {2,300000}, {2,300000} }, { 0, 0, 0 } },
      two_8= { { {2,800000}, {2,800000}, {2,800000} }, { 0, 0, 0 } };

Timer_t _null  = &null,
	_one   = &one,
	_one_2 = &one_2,
	_one_8 = &one_8,
	_two_3 = &two_3,
	_two_8 = &two_8;

void test_ops ()
{  cout << "0.0: "			<< null
	<< "\n-0.0: "			<< -null
	<< "\n1.2: "			<< one_2
	<< "\n-1.2: "			<< -one_2

	<< "\n1.2+2.3 (3.5): "		<< one_2+two_3
	<< "\n1.2+1.8 (3.0): "		<< one_2+one_8
	<< "\n2.3+1.8 (4.1): "		<< two_3+one_8

	<< "\n(-1.2)-2.3 (-3.5): "	<< (-one_2)-two_3
	<< "\n(-1.2)-1.8 (-3.0): "	<< (-one_2)-one_8
	<< "\n(-2.3)-1.8 (-4.1): "	<< (-two_3)-one_8

	<< "\n(-2.3)-1.2 (-3.5): "	<< (-two_3)-one_2
	<< "\n(-1.8)-1.2 (-3.0): "	<< (-one_8)-one_2
	<< "\n(-1.8)-2.3 (-4.1): "	<< (-one_8)-two_3

	<< "\n(-1.2)+2.3 (1.1): "	<< (-one_2)+two_3
	<< "\n(-1.2)+1.8 (0.6): "	<< (-one_2)+one_8
	<< "\n(-2.3)+1.8 (-0.5): "	<< (-two_3)+one_8

	<< "\n(-2.3)+1.2 (-1.1): "	<< (-two_3)+one_2
	<< "\n(-1.8)+1.2 (-0.6): "	<< (-one_8)+one_2
	<< "\n(-1.8)+2.3 (0.5): "	<< (-one_8)+two_3

	<< "\n1.2-2.3 (-1.1): "		<< one_2-two_3
	<< "\n1.2-1.8 (-0.6): "		<< one_2-one_8
	<< "\n2.3-1.8 (0.5): "		<< two_3-one_8
   
	<< "\n";
}

// --------------------------------------------------------------------------

int main (int argc, char *argv[])
{
#if TIME_OBST
   obst_init (argc, argv);
#endif
   int choice;

   do
   {  cout << "\n\n[1] test arithmetic\n[2] test arithmetic (C)\n[3] time OBST\n[4] time timer\n[5] time time (C)\n[0] quit\n\n\t--> ";
      cin  >> choice;

      switch (choice)
      {  case 1: test_ops ();	 break;
	 case 2: cout.flush();
		 test_ops_C();	 break;
	 case 3: time_OBST ();	 break;
	 case 4: time_timer();	 break;
	 case 5: cout.flush();
		 time_timer_C(); break;
      }
   }
   while (choice != 0);

   return 0;
}
