/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 * All rights reserved.
 *
 * You can use and distribute this software under the terms of the license
 * you should have received along with this software; either version 1.1 of
 * the license, or (at your option) any later version.
 * For a copy of the license or for additional information about this software,
 * write to Xcc Software, Durlacher Allee 53, D-76131 Karlsruhe, Germany;
 * Email: obst@xcc-ka.de.
 * --------------------------------------------------------------------------
 * Method implementations for schema 'test'.
 * --------------------------------------------------------------------------
 */

#define OBST_IMP_STREAM
#include "obst_stdinc.h"

#include "obst_progstd.h"
#include "obst_err.h"
#include "test_obst.h"


// -------------------------------------------------------------------------
externC void print_obj (char*, sos_Object);

EXPORT void print_obj (char* title, sos_Object o)
{  sos_Id self = o._self_id(),
          tp   = o._type_id();

   cout << title << ": { self.[ct:" << self.container()
        << " os:" << self.offset()
        << "] tp.[ct:" << tp.container() << " os:" << tp.offset()
        << "] _impl.[" << *(void**)((char*)&o + 16)<< "] }\n";
}

LOCAL void print_int (char* title, sos_Int i)
{  cout << title << ": { i:" << i << " }\n";
}

// -------------------------------------------------------------------------

EXPORT void TestC::ref2_1 (sos_Object& p1, sos_Object p2)
{  print_obj ("TestC::ref2_1/p1", p1);
   print_obj ("TestC::ref2_1/p2", p2);

   p1 = make_sos_Int_object (1234);

   print_obj ("TestC::ref2_1/p1", p1);
}

EXPORT void TestC::ref2_2 (sos_Object p1, sos_Object& p2)
{  print_obj ("TestC::ref2_2/p1", p1);
   print_obj ("TestC::ref2_2/p2", p2);

   p2 = make_sos_Int_object (1234);

   print_obj ("TestC::ref2_2/p2", p2);
}

EXPORT void TestC::ref3_12 (sos_Object& p1, sos_Object p2, sos_Object& p3)
{  print_obj ("TestC::ref3_12/p1", p1);
   print_obj ("TestC::ref3_12/p2", p2);
   print_obj ("TestC::ref3_12/p3", p3);

   p1 = make_sos_Int_object (1234);

   print_obj ("TestC::ref3_12/p1", p1);
   print_obj ("TestC::ref3_12/p3", p3);
}

EXPORT TestU TestC::get_u (TestU p1)
{  print_obj ("TestC::get_u/p1", p1);

   TestU result = 1234;

   print_obj ("TestC::get_u/result", result);
   return result;
}

// -------------------------------------------------------------------------

EXPORT void TestC::syserr ()
{  err_raise (err_SYS, "... SYSTEM ERROR - testing ...", "TestC::doit");
   cout << "done\n";
}

// -------------------------------------------------------------------------

EXPORT void TestC::dflt (sos_Int i, sos_Char ch, sos_Float f, Index idx,
			 sos_Pointer p, sos_Container ct, cci_Fun fct,
			 sos_Object o)
{  print_obj("TestC::dflt", o);
   cout << ", sos_Int:" << i
        << ", sos_Char:" << (int)ch
        << ", sos_Float:" << f
        << ", Index:" << idx
        << ", sos_Pointer:" << p
        << ", sos_Container:" << ct
        << ", cci_Fun:" << (void*)fct
        << "\n";
}
