/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 * All rights reserved.
 *
 * You can use and distribute this software under the terms of the license
 * you should have received along with this software; either version 1.1 of
 * the license, or (at your option) any later version.
 * For a copy of the license or for additional information about this software,
 * write to Xcc Software, Durlacher Allee 53, D-76131 Karlsruhe, Germany;
 * Email: obst@xcc-ka.de.
 * --------------------------------------------------------------------------
 * Simple main module to check the interplay of the C / C++ compilers with
 * respect to constructors.
 *
 * This module is compiled once with a C++ compiler, then twice again by a
 * C++ and a C compiler. The preprocessor constant COMPILE_MAIN is defined
 * for the two latter compilations.
 *
 * Expected result: Global constructors, destructors are not called properly,
 * if the main function is compiled with a C compiler - even if the final
 * linking stage is performed by a C++ compilation driver.
 * --> When linking C and C++ code, the main function must be compiled with
 *     a C++ compiler, the C++ compilation driver is also to perform the final
 *     linking stage.
 *
 * Correct output would be:
 *	C()
 *	goodbye world.
 *	~C()
 * --------------------------------------------------------------------------
 */
#define OBST_IMP_FORMATTED_IO
#include "obst_stdinc.h"

#ifdef COMPILE_MAIN
int main ()
{  printf ("goodbye world.\n");

   return 0;
}

#else
class C
{
 public:
   C() { printf ("C()\n");  }
  ~C() { printf ("~C()\n"); }
};

C c;
#endif
