/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 * All rights reserved.
 *
 * You can use and distribute this software under the terms of the license
 * you should have received along with this software; either version 1.1 of
 * the license, or (at your option) any later version.
 * For a copy of the license or for additional information about this software,
 * write to Xcc Software, Durlacher Allee 53, D-76131 Karlsruhe, Germany;
 * Email: obst@xcc-ka.de.
 * --------------------------------------------------------------------------
 * This file serves as the source for an interactive test program as well as
 * the source for a non-interactive program intended for profiling.
 * A compact C++ version of the loops contained here is contained in
 * test_CppLoop.C.
 * --------------------------------------------------------------------------
 */

#define OBST_IMP_STDCONST
#include "obst_stdinc.h"
#include "c2obst.h"

/*
 * Loop over the OBST schema directory using only the basic interface.
 * For demonstration/test purposes, the access to the schema module directory
 * is not performed via "sos_Schema_module::schema_dir".
 */
void loop_schemas_basic()
{  sos_Object args[2], c_args[2];
   sos_Object rootdir, name, sdir, vobj;
   char*      str;
   int	      valid;

#ifndef PROFILE
   printf ("\n\nContents of OBST schema directory [BASIC]\n\n");
#endif
   rootdir = obst_cnt_root_object (*ROOT_CONTAINER);
   args[0] = obst_scalar2object ("sos_Container", (void*)TEMP_CONTAINER);
   name    = obst_call_classmethod ("sos_String", "create", 1, args);

   str     = "sos_schemas";
   args[0] = obst_scalar2object ("sos_Cstring", (void*)&str);
   (void)obst_call_method (&name, "assign_Cstring", 1, args);

   args[0] = name;
   sdir    = obst_call_method (&rootdir, "[]", 1, args);
   (void)obst_call_method (&name, "destroy", 0, NULL);

   args[0]   = obst_scalar2object ("sos_Container", (void*)TEMP_CONTAINER);
   c_args[0] = obst_call_method (&sdir, "open_cursor", 1, args);
   valid     = 1;
   c_args[1] = obst_scalar2object ("sos_Int", (void*)&valid);

   vobj = obst_call_method (&sdir, "is_valid", 1, c_args);
   obst_object2scalar (&vobj, (void*)&valid);

   while (valid)
   {  sos_Object strobj;
   
      args[0] = obst_call_method (&sdir, "get_role2", 1, c_args);
      name    = obst_call_method (&args[0], "get_name", 0, NULL);
      strobj  = obst_call_method (&name, "make_Cstring", 0, NULL);
      obst_object2scalar (&strobj, (void*)&str);

#ifndef PROFILE
      printf ("\t%s\n", str);
#endif
      free (str);

      vobj = obst_call_method (&sdir, "to_succ", 2, c_args);
      obst_object2scalar (&vobj, (void*)&valid);
   }
   obst_call_method (&sdir, "close_cursor", 1, c_args);
}

/*
 * Loop over the OBST schema directory using the extended interface
 * except for the aggregate looping convenience routines.
 * For demonstration/test purposes, the access to the schema module directory
 * is not performed via "sos_Schema_module::schema_dir".
 */
void loop_schemas_medium()
{  sos_Object rootdir, name, sdir, cursor, int_1, vobj;
   char	      *str;

#ifndef PROFILE
   printf ("\n\nContents of OBST schema directory [MEDIUM]\n\n");
#endif
   rootdir = obst_cnt_root_object (*ROOT_CONTAINER);
   name    = obst_str2obj ("sos_schemas");
   sdir    = obst_vcall_method (&rootdir, "[]", 1, name);
   obst_vcall_method (&name, "destroy", 0);

   cursor = obst_vcall_method (&sdir, "open_cursor", 1,
				      obst_cnt2obj (*TEMP_CONTAINER));
   int_1  = obst_int2obj ((sos_Int)1);
   vobj   = obst_vcall_method (&sdir, "is_valid", 1, cursor);

   while (obst_object2enum (&vobj))
   {  sos_Object obj;

      obj  = obst_vcall_method (&sdir, "get_info", 1, cursor);
      name = obst_vcall_method (&obj, "get_name", 0);
      str  = obst_obj2str (&name);

#ifndef PROFILE
      printf ("\t%s\n", str);
#endif
      free (str);

      vobj = obst_vcall_method (&sdir, "to_succ", 2, cursor, int_1);
   }
   obst_vcall_method (&sdir, "close_cursor", 1, cursor);
}

/*
 * Loop over the OBST schema directory using all applicable extensions.
 *
 * (The use of sos_Schema_module::schema_dir seems to be substantially
 *  slower than the above used access scheme.)
 */

void loop_schemas_xtnd()
{  sos_Object sdir, rootdir, name;

#ifndef PROFILE
   printf ("\n\nContents of OBST schema directory [XTND]\n\n");
#endif
   sdir = obst_vcall_classmethod ("sos_Schema_module", "schema_dir", 0);
   obst_iterate (&sdir)
      sos_Object obj, name;
      char       *str;

      obj  = obst_iterate_role2();
      name = obst_vcall_method (&obj, "get_name", 0);
      str  = obst_obj2str (&name);

#ifndef PROFILE
      printf ("\t%s\n", str);
#endif
      free (str);
   obst_iterate_end (&sdir)
}

/*
 * Main menu in the interactive mode.
 * Otherwise, the routine to be profiled and the number of runs are expected
 * as command line arguments.
 * The next two arguments may be used to set the flags 'obst_check_args',
 * 'obst_catch_syserrs'. If present, a flag is set if the corresponding
 * argument starts with '+', cleared otherwise.
 */
int C_main (argc, argv)
	int  argc;
	char *argv[];
{
#ifdef PROFILE
   int routine = atoi (argv[1]),
       runs    = atoi (argv[2]);
   
   if (argc > 3)
      obst_check_args    = (argv[3][0] == '+');
   if (argc > 4)
      obst_catch_syserrs = (argv[4][0] == '+');

   switch (routine)
   {  case 1: while (runs--) loop_schemas_basic();      break;
      case 2: while (runs--) loop_schemas_medium();     break;
      case 3: while (runs--) loop_schemas_xtnd();       break;
   }

#else
   int choice;
   do
   {  printf ("\n\n\t[1] list schemas (basic)\n\t[2] list schemas (medium)\n\t[3] list schemas (xtnd)\n\t[0] quit\n\n\t--> ");

      if (scanf("%d", &choice) != 1)
	 choice = -1;
      while (getchar() != '\n')
	 ;

      switch (choice)
      {  case 1: loop_schemas_basic();	break;
         case 2: loop_schemas_medium();	break;
         case 3: loop_schemas_xtnd();	break;
      }
   }
   while (choice);
#endif
   return 0;
}
