/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 * All rights reserved.
 *
 * You can use and distribute this software under the terms of the license
 * you should have received along with this software; either version 1.1 of
 * the license, or (at your option) any later version.
 * For a copy of the license or for additional information about this software,
 * write to Xcc Software, Durlacher Allee 53, D-76131 Karlsruhe, Germany;
 * Email: obst@xcc-ka.de.
 *
 * --------------------------------------------------------------------------
 * Interface definitions for the C --> OBST Interface: Utilities
 * --------------------------------------------------------------------------
 * ORIGINAL: D. Theobald				DATE: 14/2/93
 * --------------------------------------------------------------------------
 */
/* tclOBST LIBRARY MODULE */

#define OBST_IMP_STDCONST
#define OBST_IMP_MALLOC
#define OBST_IMP_STRINGOP
#define OBST_IMP_SORT_SEARCH
#include "obst_stdinc.h"

#include "_c2obst.h"

#if OBSTVERSIONNO >= 336
#  define _const_   _tsearch_const_
#  define _cmpfct_t tsearch_cmpfct_t
#else
#  define _const_   _qsort_const_
#  define _cmpfct_t tsearch_cmpfct_t
#endif

/*
 * Map strings into an unique storage representation.
 * Two strings resulting from this function are equal, iff their addresses
 * are identical.
 * It is an error to modify a string resulting from this function.
 * The result string will not be identical to the argument string, i.e. the
 * argument string might be modified afterwards.
 *
 * (Compact version used here - see test program for a more readable form.
 *  Remark: These routines do not deserve to be type-checked by a C++ compiler.)
 */
static int strcmpfct (s1ptr, s2ptr)
   _const_ void* s1ptr;
   _const_ void* s2ptr;
{
   return strcmp(*(char**)s1ptr, *(char**)s2ptr);
}
 
char* obst_uniqueString (str)
   const char* str;
{
   static char* *rootptr = NULL;
   static char* first_node;
   static char* *nptr    = &first_node;
          char* *found;
 
   T_PROC ("obst_uniqueString")
   TT (c2o_VL, T_ENTER);

   *nptr = (char*)str;
   if (nptr == (found = *(char***)tsearch ((_const_ void*)nptr,
					   (void**)&rootptr,
                                           (_cmpfct_t*)strcmpfct)))
   {  *nptr = obst_strdup(str);
      nptr  = (char* *)malloc ((size_t)sizeof(char*));
   }
   TT (c2o_VL, T_LEAVE);
   return *found;
}

/* -------------------------------------------------------------------- */

#define check_type(tp,tpname,wanted) \
   if (sizeof(tp) != (wanted)) \
      obst_err_raise (err_SYS, \
		      "inconsistent C mapping for C++ type", tpname, FALSE)

/*
 * Initialize the C interface with a C routine and check the consistency
 * of the mapping of the C++ types to C types.
 */
void _c2obst_Cinit()
{  static int initialized = 0;

   T_PROC ("_c2obst_Cinit")
   TT (c2o_L, T_ENTER);

   if (initialized) { TT (c2o_L, T_LEAVE); return; }
   initialized = 1;

   check_type (sos_Char,      "sos_Char",      1);	/* This check is of */
   check_type (sos_Int,       "sos_Int",       4);	/* course rather    */
   check_type (sos_Cstring,   "sos_Cstring",   4);	/* rough; but we    */
   check_type (sos_Pointer,   "sos_Pointer",   4);	/* assume, that the */
   check_type (sos_Offset,    "sos_Offset",    4);	/* C type has the   */
   check_type (cci_Fun,       "cci_Fun",       4);	/* right flavor.    */
   check_type (sos_Container, "sos_Container", 4);
#if OBSTVERSIONNO >= 343
   check_type (sos_Short,     "sos_Short",     2);
   check_type (sos_Double,    "sos_Double",    8);
#endif
   check_type (sos_Id,        "sos_Id",        OBST_ID_SIZE);
   check_type (sos_Object,    "sos_Object",    OBST_OBJ_SIZE);

   TT (c2o_L, T_LEAVE);
}
