#ifndef __C2OBST_H
#define __C2OBST_H
/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 * All rights reserved.
 *
 * You can use and distribute this software under the terms of the license
 * you should have received along with this software; either version 1.1 of
 * the license, or (at your option) any later version.
 * For a copy of the license or for additional information about this software,
 * write to Xcc Software, Durlacher Allee 53, D-76131 Karlsruhe, Germany;
 * Email: obst@xcc-ka.de.
 *
 * --------------------------------------------------------------------------
 * Interface definitions for the C --> OBST Interface: Utilities
 * --------------------------------------------------------------------------
 * ORIGINAL: D. Theobald				DATE: 14/2/93
 * --------------------------------------------------------------------------
 */
#include "c2obst.h"

#ifdef __cplusplus
extern "C" {
#endif


#define ERR_HANDLING_WRAPPER(standard_code, exception_code)		\
   if (c2obst_ctrls.catch_syserrs)     					\
   {  c2obst_ctrls.syserr=NULL;		       				\
      err_block     { standard_code }					\
      err_exception { c2obst_ctrls.syserr=err_last_raised();		\
		      exception_code }					\
      err_block_end }							\
   else { standard_code }

/*
 * NOTE: `standard_code' must not be left via `return' since this will cause
 *	 a memory leak (see err(3)).
 */

extern err_msg err_NO_OBJECT;

extern char*   obst_uniqueString __FSIG_((const char*));
extern void    _c2obst_Cinit     __FSIG_(());
extern void    _c2obst_init      __FSIG_(());

#ifdef __cplusplus
extern char* c2obst_encode_type (const sos_Type&);

}
#endif
#endif
