# --------------------------------------------------------------------------
# Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
# All rights reserved.
#
# You can use and distribute this software under the terms of the license
# you should have received along with this software; either version 1.1 of
# the license, or (at your option) any later version.
# For a copy of the license or for additional information about this software,
# write to Xcc Software, Durlacher Allee 53, D-76131 Karlsruhe, Germany;
# Email: obst@xcc-ka.de.
# --------------------------------------------------------------------------
# Module: mtaTool_obst.tcl
# Tcl version: 6.7 (Tcl/Tk/XF)
# Tk version: 3.2
# XF version: 2.2
#

# module contents
global moduleList
global autoLoadList
set moduleList(mtaTool_obst.tcl) { mta::selectSchema mta::selectType mta::selectElem mta::showSchemaDir mta::showEnumType mta::showExternType mta::showClassType mta::showTypedefType mta::showUnionType mta::method_signature mta::method_name mta::name}
set autoLoadList(mtaTool_obst.tcl) {0}

# procedures to show toplevel windows


# User defined procedures


# ---------
proc mta::selectSchema { index} {
#
# in:  index in schema display list (counted from 0)
# out: --
#
# Select the given schema from the schema display list, store its type table in
# mta::currentTypeTbl, redefine the type display list by filling it with the
# types of the selected schemas, and trigger the further redisplay by selecting
# the first of these types.
#
# If the given index points beyond the end of the schema list, no schema/type
# table is selected, but the type display list is cleared and the further
# redisplay is triggered.
#
global mta::schemaDir mta::currentTypeTbl

set SchemaBox [SymbolicName mta::SchemaListBox]
set TypeBox   [SymbolicName mta::TypeListBox]

$TypeBox delete 0 end

if {$index >= [$SchemaBox size]} then {
   $SchemaBox select clear
} else {
   $SchemaBox select from $index

   set SchemaNm  	   [OBST tmpstr [$SchemaBox get $index]]
   set mta::currentTypeTbl [[${mta::schemaDir} {[]} $SchemaNm] get_type_table]
   $SchemaNm destroy

   set TypeList {}
   agg loop ${mta::currentTypeTbl} {

      # exclude descriptions of generic class types

      if {[OBST has_type [agg current role2] sos_Class_type]
          && [[agg current role2] is_generic_class] == "TRUE"} then continue

      lappend TypeList [[agg current role1] make_Cstring]
   }
   foreach Type [lsort $TypeList] {
      $TypeBox insert end $Type
   }
   $TypeBox xview 0
   $TypeBox yview 0
}
mta::selectType 0
}


# ---------
proc mta::selectType { index} {
#
# in:  index in type display list (counted from 0)
# out: --
#
# Select the given schema type the type display list, store it in
# mta::currentType, redefine the type element list by filling it with the
# type elements of the selected type, and trigger the further redisplay by
# selecting the first of these elements.
#
# If the given index points beyond the end of the type list, no type is
# selected, but the type element list is cleared and the further redisplay is
# triggered.
#
# The displayed type elements depend on the type kind and additional view
# parameters adjustable by the `View Parameter' dialog. These view parameters
# are copied here into the global variables which are used when the type
# element list is built up. Hence, changes of the view parameters take only
# visible effect after invoking this procedure.
#
global mta::elemKind mta::elemScope mta::_elemKind mta::_elemScope
global mta::currentTypeTbl mta::currentType

set TypeBox [SymbolicName mta::TypeListBox]
set ElemBox [SymbolicName mta::ElemListBox]
set TextBox [SymbolicName mta::TextBox]

$ElemBox delete 0 end

if {$index >= [$TypeBox size]} then {
   $TypeBox select clear
} else {
   $TypeBox select from $index

   set TypeNm	        [OBST tmpstr [$TypeBox get $index]]
   set mta::currentType [${mta::currentTypeTbl} {[]} $TypeNm]
   $TypeNm destroy

   set mta::elemKind ${mta::_elemKind}
   set mta::elemScope ${mta::_elemScope}

   regexp sos_(.*)_type [mta::name [${mta::currentType} type]] dummy kind

   mta::show${kind}Type

   $ElemBox xview 0
   $ElemBox yview 0
}
mta::selectElem 0
}


# ---------
proc mta::selectElem { index} {
#
# in:  index in type element display list (counted from 0).
# out: --
#
# Select the given element in the type element list and display the
# corresponding type details. If the given index points beyond the end of the
# element list, or if there are no details to be displayed for the currently
# selected type, the box to hold type details is just cleared.
#
# The type details are
#  - enumeration type
#	Index of the enumeration literal in the enumeration definition
#	(counted from 1).
#  - external type
#	Size of the host language representation in bytes.
#  - class type
#	The method signature of either the selected method, or the accessor
#	methods of the selected components.
#	An accessor method is not displayed if it is not inherited (it is then
#	a private method of a base class).
#  - typedef type
#	The type denoted by the typedef type.
#	A chain of typedef's is resolved to the finally referenced non-typedef
#	type.
#
global mta::currentType mta::elemKind

set ElemBox [SymbolicName mta::ElemListBox]
set TextBox [SymbolicName mta::TextBox]

$TextBox configure -state normal
$TextBox delete 1.0 end

if {$index >= [$ElemBox size]} then {
   $ElemBox select clear
} else {
   $ElemBox select from $index
}
set Elem [$ElemBox get $index]

case [mta::name [${mta::currentType} type]] in {
   sos_Enum_type {
      if {"$Elem" != ""} then {
         set idx 1
         agg loop [${mta::currentType} get_literals] {
	    if {[[agg current] make_Cstring] == $Elem} break
	    set idx [expr {$idx + 1}]
         }
         $TextBox insert end "enumeration index: $idx\n"
   }}
   sos_Extern_type {
      $TextBox insert end "size: [${mta::currentType} get_object_size] bytes\n"
   }
   sos_Class_type {
      if {"$Elem" != ""} then {
         case ${mta::elemKind} in {
            METHODS {
	       set pcard -1
	       if {![regexp {operator([^A-Za-z_].*)} "$Elem" dummy mname]} {
	          regexp "(.*)/(.*)" "$Elem" dummy mname pcard
               }
               $TextBox insert end "[mta::method_signature $mname $pcard]\n"
	    }
	    COMPONENTS {
	       $TextBox insert end "[mta::method_signature get_$Elem 0]\n"
	       $TextBox insert end "[mta::method_signature set_$Elem 1]\n"
	    }
   }}}
   sos_Typedef_type {
      $TextBox insert end "refers to: [mta::name [${mta::currentType} make_type]]\n"
   }
}
$TextBox configure -state disabled
$TextBox yview 0
}


# ---------
proc mta::showSchemaDir {} {
#
# in/out: --
#
# Store the schema directory in mta::schemaDir, fill the schema display list
# with the currently known schemas and trigger a complete redisplay by
# selecting the first of these schemas.
#
global mta::schemaDir

set SchemaBox 	   [SymbolicName mta::SchemaListBox]
set mta::schemaDir [mcall sos_Schema_module::schema_dir]

$SchemaBox delete 0 end

set SchemaList {}
agg loop ${mta::schemaDir} {
   lappend SchemaList [[agg current role1] make_Cstring]
}
foreach Schema [lsort $SchemaList] {
   $SchemaBox insert end $Schema
}
$SchemaBox yview 0

mta::selectSchema 0
}


# ---------
proc mta::showEnumType {} {
#
# in/out: --
#
# Show type elements of mta::currentType which must be an enumeration type.
#
global mta::currentType

set ElemBox [SymbolicName mta::ElemListBox]

agg loop [${mta::currentType} get_literals] {
   lappend LiteralList [[agg current] make_Cstring]
}
foreach Literal [lsort $LiteralList] {
   $ElemBox insert end $Literal
}
}


# ---------
proc mta::showExternType {} {
#
# in/out: --
#
# Show type elements of mta::currentType which must be an external type.
# Currently, there are no such elements, but just type details.
#
}


# ---------
proc mta::showClassType {} {
#
# in/out: --
#
# Display type elements of mta::currentType which must be a class type,
# according to the current view parameters.
#
global mta::elemKind mta::elemScope mta::currentType 

set ElemBox 	  [SymbolicName mta::ElemListBox]
set currentRoot	  [${mta::currentType} root]
set ClassElemList {}

case "${mta::elemScope}-${mta::elemKind}" in {
   ALL-METHODS {
      agg loop [${mta::currentType} get_methods] {
	 agg loop [agg current role2] {
	    lappend ClassElemList [mta::method_name [agg current]]
      }}}
   LOCAL-METHODS {
      agg loop [${mta::currentType} get_local_methods] {
	 lappend ClassElemList [mta::method_name [agg current]]
      }}
   ALL-COMPONENTS {
      agg loop [${mta::currentType} get_components] {
	 lappend ClassElemList [mta::name [agg current]]
      }}
   LOCAL-COMPONENTS {
      agg loop [${mta::currentType} get_components] {
	 set mrclass [[[[agg current] get_get_method] get_defined_in] root]
	 if {$mrclass == $currentRoot} {
	    lappend ClassElemList [mta::name [agg current]]
      }}}
   ALL-BASE_CLASSES {
      agg loop [${mta::currentType} get_super_closure] {
	 set sclass [[[agg current] get_super_class] make_type]

	 if {$sclass != ${mta::currentType}} {
	    lappend ClassElemList [mta::name $sclass]
      }}}
   LOCAL-BASE_CLASSES {
      agg loop [${mta::currentType} get_super_classes] {
	 if {[[agg current] get_is_direct] == "TRUE"} {
	    set sclass [[[agg current] get_super_class] make_type]
	    lappend ClassElemList [mta::name $sclass]
      }}}
}

foreach Elem [lsort $ClassElemList] {
   $ElemBox insert end $Elem
}
}


# ---------
proc mta::showTypedefType {} {
#
# in/out: --
#
# Show type elements of mta::currentType which must be a typedef type.
# Currently, there are no such elements, but just type details.
#
}


# ---------
proc mta::showUnionType {} {
#
# in/out: --
#
# Show type elements of mta::currentType which must be an union type.
#
global mta::currentType

set ElemBox [SymbolicName mta::ElemListBox]

agg loop [${mta::currentType} get_united] {
   lappend UnionList [mta::name [agg current]]
}
foreach UnionType [lsort $UnionList] {
   $ElemBox insert end $UnionType
}
}


# ---------
proc mta::method_signature { mname pcard} {
#
# in : method name,
#      arity (not used if the method name is unambiguous)
# out: method signature as string, or "" if the denoted method is not found.
#
# The resulting signature is such that it could be used in an OBST schema
# to define the method.
# Note, that method name and arity unambiguously identifies a method within
# the scope of a (class) type according to the OBST data model.
#
global mta::currentType

set method  ""
set nameStr [OBST tmpstr $mname]
set mlist   [[${mta::currentType} get_methods] {[]} $nameStr]
$nameStr destroy

if {[agg card $mlist] == 1} then {
   set method [$mlist get_nth 1]
} else {
   agg loop $mlist {
      if {[agg card [[agg current] get_params]] == $pcard} {
	 set method [agg current]
	 break
   }}
}
if {$method == ""} then return

case [$method get_kind] in {
   sos_PUBLIC    {set result "public: "}
   sos_PROTECTED {set result "protected: "}
   sos_PRIVATE   {set result "private: "}
}
if {[$method get_is_static]   == "TRUE"} {append result "static "  }
if {[$method get_is_definite] == "TRUE"} {append result "definite "}
if {[$method get_is_abstract] == "TRUE"} {append result "abstract "}

append result "[mta::name [[$method get_result_type] make_type]] "

if {[$method get_is_operator] == "TRUE"} {append result "operator" }

append result "[mta::name $method] ("

set add_comma 0
agg loop [$method get_params] {
   if {$add_comma} then {
      append result ", "
   } else {
      set add_comma 1
   }
   append result [mta::name [[[agg current] get_type] make_type]]
   if {[[agg current] get_is_ref] == "TRUE"} {
      append result "&"
   }
}
return "$result)"
}


# ---------
proc mta::method_name { method} {
#
# in:  Handle of instance of sos_Method.
# out: String to be displayed as method name.
#
# The result string of an operator method will be "operator" with the appended
# operator sign. Otherwise, the result will be the method name with appended
# arity.
# The result string is unique among the `method_name's for a single class.
#
if {[$method get_is_operator] == "TRUE"} then {
   return "operator[mta::name $method]"
} else {
   return "[mta::name $method]/[agg card [$method get_params]]"
}
}


# ---------
proc mta::name { obj} {
#
# in : Handle of instance of subtype of sos_Named.
# out: Value of component `name'.
#
return [[$obj get_name] make_Cstring]
}


# Internal procedures

# eof
#

