#!../../bin/wish -f
# --------------------------------------------------------------------------
# Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
# All rights reserved.
#
# You can use and distribute this software under the terms of the license
# you should have received along with this software; either version 1.1 of
# the license, or (at your option) any later version.
# For a copy of the license or for additional information about this software,
# write to Xcc Software, Durlacher Allee 53, D-76131 Karlsruhe, Germany;
# Email: obst@xcc-ka.de.
# --------------------------------------------------------------------------
#
# list_meta - 14/12/92 - dietmar theobald
#
# list_meta
#
# Lists some selected portions of the OBST meta database, thereby demonstrating
# some features of the tclOBST binding.

#
# Process a schema module.
#
proc LM::module { module } {
   puts stdout "schema [LM::named $module] {\n  imports: " nonewline

   agg loop [$module get_imports] {
      puts stdout "[LM::named [[agg current] get_module]] " nonewline
   }
   puts stdout "\n  types ([agg card [$module get_types]]):"

   agg loop [$module get_types] {
      LM::type [agg current]
   }
   puts stdout "}\n"
}

#
# Process a type object, discarding auxiliary types.
# note: '[agg current role2 -1]' refers to the outer loop in the main section.
#
proc LM::type { type } {
   puts stdout [format "\t%-50s%s" \
		       [LM::named [agg current role2 -1]]::[LM::named $type] \
		       ([LM::named [$type type]]) \
	       ]
}

#
# pre: [OBST isa $obj sos_Named]
#
proc LM::named { obj } {
   return [[$obj get_name] make_Cstring]
}


# ------ main -------

# simpler expression for schema directory: mcall sos_Schema_module::schema_dir
#
# here: access the root object of the root container,
#	apply operator[] on this object with argument "sos_schemas"

tclOBST bind

# activate to turn on container statistics collection
tclOBST trace "" {id#26-27}

set rootdir   [cnt root_object [OBST const ROOT_CONTAINER]]
set schemadir [$rootdir {[]} [OBST tmpstr sos_schemas]]

agg loop $schemadir {
   LM::module [agg current role2]
}

puts stdout [tclOBST statistics]

catch {destroy .}
catch {exit 0}
