# --------------------------------------------------------------------------
# Copyright 1993-1994 by Forschungszentrum Informatik (FZI)
# All rights reserved.
#
# You can use and distribute this software under the terms of the license
# you should have received along with this software; either version 1.1 of
# the license, or (at your option) any later version.
# For a copy of the license or for additional information about this software,
# write to Xcc Software, Durlacher Allee 53, D-76131 Karlsruhe, Germany;
# Email: obst@xcc-ka.de.
# --------------------------------------------------------------------------
# Module: lazy_bind.tcl
# Tcl version: 7.0 (Tcl/Tk/XF)
# Tk version: 3.3
# XF version: 2.2
#

# module contents
global moduleList
global autoLoadList
set moduleList(lazy_bind.tcl) { }
set autoLoadList(lazy_bind.tcl) {0}

# procedures to show toplevel windows


# User defined procedures


# ---------
catch {rename unkown t2o_unknown}

proc unknown { cmd args } {
#
# Unkown procedure which performs lazy binding (see tclOBST documentation)
# for (tcl)OBST object handles, i.e. it will transparently execute
# `tclOBST bind <object handle>' if necessary.
#
   switch -glob $cmd \
      obst???????????????????????????????? {
	 tclOBST bind $cmd
	 uplevel 1 $cmd $args
      } \
      default {
	 uplevel 1 t2o_unknown $args
      }
}
