# --------------------------------------------------------------------------
# Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
# All rights reserved.
#
# You can use and distribute this software under the terms of the license
# you should have received along with this software; either version 1.1 of
# the license, or (at your option) any later version.
# For a copy of the license or for additional information about this software,
# write to Xcc Software, Durlacher Allee 53, D-76131 Karlsruhe, Germany;
# Email: obst@xcc-ka.de.
# --------------------------------------------------------------------------
# Module: infobox_tk.tcl
# Tcl version: 6.7 (Tcl/Tk/XF)
# Tk version: 3.2
# XF version: 2.2
#

# module contents
global moduleList
global autoLoadList
set moduleList(infobox_tk.tcl) { infobox::displayInfo infobox::displayText .infobox}
set autoLoadList(infobox_tk.tcl) {0}

# procedures to show toplevel windows


# procedure to show window ShowWindow.infobox
proc ShowWindow.infobox { args} {
# xf ignore me 7

  # build widget .infobox
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .infobox"
  } {
    catch "destroy .infobox"
  }
  toplevel .infobox      -borderwidth {1}

  # Window manager configurations
  global tkVersion
  wm positionfrom .infobox ""
  wm sizefrom .infobox ""
  wm grid .infobox 60 28 7 13
  wm maxsize .infobox 1000 900
  wm minsize .infobox 10 10
  wm title .infobox {info}

  # bindings
  bind .infobox <Key-F10> {tk_firstMenu %W}
  bind .infobox <Mod2-Key> {tk_traverseToMenu %W %A}

  # build widget .infobox.button5
  button .infobox.button5     -command {[SN infobox::text] configure -state normal
[SN infobox::text] delete 1.0 end

DestroyWindow[SN infobox::root]}     -text {dismiss}

  # build widget .infobox.frame
  frame .infobox.frame     -relief {raised}

  # build widget .infobox.frame.scrollbar1
  scrollbar .infobox.frame.scrollbar1     -command {.infobox.frame.text2 yview}     -width {10}

  # build widget .infobox.frame.text2
  text .infobox.frame.text2     -borderwidth {1}     -height {28}     -padx {2}     -pady {2}     -relief {raised}     -setgrid {1}     -width {60}     -wrap {none}     -yscrollcommand {.infobox.frame.scrollbar1 set}

  # pack widget .infobox.frame
  pack append .infobox.frame     .infobox.frame.scrollbar1 {left frame center filly}     .infobox.frame.text2 {top frame center expand fill}

  # pack widget .infobox
  pack append .infobox     .infobox.frame {top frame center expand fill}     .infobox.button5 {bottom frame center pady 4}

  .infobox.frame.text2 insert end {}



  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .infobox"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.infobox {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .infobox]" != ""} {
      global xfShowWindow.infobox
      set xfShowWindow.infobox 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .infobox; XFEditSetShowWindows"
    }
  } {
    catch "destroy .infobox"
    update
  }
}


# User defined procedures


# ---------
proc infobox::displayInfo { topic} {
#
# in:  topic to be displayed
# out: --
#
# Displays informations about the denoted topic in the global info text box.
#  - error: Display $errorInfo.
#  - about: Display informations about the running program as given via the
#	    variable infobox::aboutText.
#
global errorInfo infobox::aboutText

case $topic in {
   error   {infobox::displayText [expr {[info exists errorInfo] ? [set errorInfo] : ""}]
	   }
   about   {infobox::displayText [set infobox::aboutText]
	   }
   default {infobox::displayText "*** unknown info type: $topic"
	   }
}
}


# ---------
proc infobox::displayText { text} {
#
# in:  text to be displayed.
# out: --
#
# Brings up a scrollable read-only text box to display the given text.
# There is only one such box.
#
set Box     [SymbolicName infobox::root]
set TextBox [SymbolicName infobox::text]

if {[catch "winfo ismapped Box"]} ShowWindow$Box

$TextBox configure -state normal
$TextBox delete 1.0 end
$TextBox insert end [set text]
$TextBox configure -state disabled
}


# Internal procedures

# eof
#

