# --------------------------------------------------------------------------
# Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
# All rights reserved.
#
# You can use and distribute this software under the terms of the license
# you should have received along with this software; either version 1.1 of
# the license, or (at your option) any later version.
# For a copy of the license or for additional information about this software,
# write to Xcc Software, Durlacher Allee 53, D-76131 Karlsruhe, Germany;
# Email: obst@xcc-ka.de.
# --------------------------------------------------------------------------
# Module: dirTool_obst.tcl
# Tcl version: 6.7 (Tcl/Tk/XF)
# Tk version: 3.2
# XF version: 2.2
#

# module contents
global moduleList
global autoLoadList
set moduleList(dirTool_obst.tcl) { dir::append_path dir::readCONTAINER dir::lookup_OBSTobject dir::read_OBSTobject dir::display_directory dir::copy_container dir::do_copy_container dir::list_callback}
set autoLoadList(dirTool_obst.tcl) {0}

# procedures to show toplevel windows


# User defined procedures


# ---------
proc dir::append_path { path} {
#
# in:  relative/absolute OBST path
# out: resulting OBST path
#
# Appends a given relative path to $dir::objectPath whereby the relative
# paths ".", ".." and relative paths starting with "/" are handled and
# normalized immediately.
# An absolute path will be returned directly.
#
global dir::objectPath

case $path in {
   /*	   {set newPath $path}
   ..	   {set newPath [file dirname ${dir::objectPath}]
	    if {$newPath == "."} then {set newPath "/"}
	   }
   .	   {set newPath ${dir::objectPath}}
   default {set newPath "[string trimright ${dir::objectPath} /]/$path"}
}

return $newPath
}


# ---------
proc dir::readCONTAINER {} {
# 
# in:  --
# out: UNIX pathname of OBST container directory.
#
# Retrieve the name of the OBST container directory from the process
# environment and exit if no definition is found.
#
global env

if {[catch {set env(OBSTCONTAINER)} result]} then {
   if {[catch {set env(SOSCONTAINER)} result]} then {
      puts stderr {*** $OBSTCONTAINER not defined}
      destroy .
   }
}
return $result
}


# ---------
proc dir::lookup_OBSTobject { path} {
#
# in:  Absolute pathname of object in OBST root directory hierarchy.
# out: Handle of denoted object, or NO_OBJECT handle in case of error.
#
set name [OBST tmpstr $path]
set obj	 [mcall sos_Directory::lookup $name]

$name destroy

return $obj
}


# ---------
proc dir::read_OBSTobject { path} {
#
# in:  OBST pathname of object in OBST root directory hierarchy.
# out: (unsorted) list of associated entries, empty in case of error.
#
# Read the denoted OBST object and construct the list of associated entries.
#
# Each entry consists of the (OBST) path relative to the given path plus the
# name of the type of the corresponding object (in parenthesis).
#
# Each list starts with the pseudo-entry "." for the given object. In case of
# a directory, the list does also contain the directory elements.
#
set obj	[dir::lookup_OBSTobject $path]

if {$obj == [OBST const NO_OBJECT]} return {}

lappend result ". ([[[$obj type] get_name] make_Cstring])"

if {[OBST is_some $obj sos_Object_Directory]} then {
   agg loop $obj {
      set type "[[[[agg current role2] type] get_name] make_Cstring]"
      lappend result "[[agg current role1] make_Cstring] ($type)"
   }
}
return $result
}


# ---------
proc dir::display_directory { path} {
#
# in:  OBST path of object relative to currently displayed object, or absolute
#      object path in OBST root directory hierarchy.
# out: --
#
# Display the denoted object (associated entries, path) in the main dialog.
# There are two pseudo-entries ("..", ".") for each object. In case of a
# directory object, there are additional entries for the directory contents.
# The displayed entries are lexicographically sorted, which works as expected
# for `regular` object names (C++ type identifiers).
#
#
global dir::objectPath

set Box     [SymbolicName dir::ObjectBox]
set newPath [dir::append_path $path]

if {[catch "dir::read_OBSTobject $newPath" entryList]} then {
   infobox::displayInfo error
} else {
   set dir::objectPath $newPath

   $Box delete 0 end
   $Box insert end ".."
   foreach entry [lsort $entryList] {
      $Box insert end $entry
   }
}
}


# ---------
proc dir::copy_container {} {
#
# in/out: --
#
# Iff there is a single selected object, activate `Copy Container' dialog for
# this object.
#
global dir::selectedObjPath

set Box     [SymbolicName dir::ObjectBox]
set SelList [$Box curselection]

if {[llength $SelList] == 1} then {
   set relpath    	    [lindex [$Box get [lindex $SelList 0]] 0]
   set dir::selectedObjPath [dir::append_path $relpath]

   ShowWindow[SymbolicName dir::CopyCntBox]
}
}


# ---------
proc dir::do_copy_container {} {
#
# in/out: --
#
# Copy container/object into the container directory specified in the
# `Copy Container' dialog, display the result of this copy operation, and
# close the dialog.
#
# The copy is performed in a subprocess since the container directory has
# to be changed.
#
global dir::foreignCntDir dir::containerPath        dir::doCopyPrg 	  dir::selectedObjPath env

set objHandle [dir::lookup_OBSTobject ${dir::selectedObjPath}]

set env(OBSTCONTAINER) ${dir::foreignCntDir}

catch "exec $env(WISH_CMD) -f ${dir::doCopyPrg} ${dir::containerPath} ${dir::selectedObjPath} $objHandle" result

infobox::displayText "$result"

DestroyWindow[SymbolicName dir::CopyCntBox]
}


# ---------
proc dir::list_callback { clicks ypos} {
#
# in:  number of button presses (1 or 2)
#      y coordinate of mouse cursor when event occurred
# out: --
# 
# Handler for button press in the object display list of the main dialog.
# The object pointed at is selected.
# In case of a double click it is additionally displayed.
#
set Box	  [SymbolicName dir::ObjectBox]
set Index [$Box nearest $ypos]

$Box select from $Index

if {$clicks > 1} then {dir::display_directory [lindex [$Box get $Index] 0]}
}


# Internal procedures

# eof
#

