#!/fzi/prost/stone/tclOBST-1.0/bin/wish -f
# XF
# create the widget hierarchy
#
# --------------------------------------------------------------------------
# Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
# All rights reserved.
#
# You can use and distribute this software under the terms of the license
# you should have received along with this software; either version 1.1 of
# the license, or (at your option) any later version.
# For a copy of the license or for additional information about this software,
# write to Xcc Software, Durlacher Allee 53, D-76131 Karlsruhe, Germany;
# Email: obst@xcc-ka.de.
# --------------------------------------------------------------------------
#
# module inclusion

# initialize global variables
proc InitGlobals {} {
  global mta::_WhichElem1
  set mta::_WhichElem1 {showMethods}
  global mta::CurrentElem
  set mta::CurrentElem {}
  global mta::_WhichElem2
  set mta::_WhichElem2 {showAll}
  global symbolicName
  set {symbolicName(mta::InfoTextBox)} {.top1.frame.text2}
  set {symbolicName(mta::SchemaListBox)} {.frame1.frame5.frame.listbox1}
  set {symbolicName(mta::TextBox)} {.frame2.frame.text2}
  set {symbolicName(root)} {.}
  set {symbolicName(mta::TypeListBox)} {.frame1.frame5.frame6.listbox1}
  set {symbolicName(mta::ElemListBox)} {.frame1.frame.listbox1}
  set {symbolicName(mta::InfoBox)} {.top1}
  set {symbolicName(mta::ViewParamBox)} {.top7}
  global mta::CurrentTypeTbl
  set mta::CurrentTypeTbl {}
  global mta::CurrentType
  set mta::CurrentType {}
  global moduleList
  set {moduleList(mtaTool.tcl)} {}
  global mta::WhichElem1
  set mta::WhichElem1 {showMethods}
  global mta::WhichElem2
  set mta::WhichElem2 {showAll}
  global mta::SchemaDir
  set mta::SchemaDir {}
}

proc ShowWindow.top1 { args} {

  # build widget .top1

  if {[string length [info commands .XFEdit]] > 0} {
    catch "XFDestroy .top1"
  } {
    catch "destroy .top1"
  }
  toplevel .top1
  .top1 configure     -borderwidth {1}
  # bindings
  tk_bindForTraversal .top1
  bind .top1 <F10> {tk_firstMenu %W} 
  bind .top1 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # Window manager configurations
  wm title .top1 {info}
  wm geometry .top1 400x342
  wm positionfrom .top1 program
  wm sizefrom .top1 user
  wm maxsize .top1 1000 900
  wm minsize .top1 10 10

  # build widget .top1.button5
  button .top1.button5
  .top1.button5 configure     -command {DestroyWindow[SymbolicName mta::InfoBox]}    -text {dismiss}
  # bindings
  tk_bindForTraversal .top1.button5
  bind .top1.button5 <F10> {tk_firstMenu %W} 
  bind .top1.button5 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .top1.frame
  frame .top1.frame
  .top1.frame configure     -geometry {30x30}    -relief {raised}
  # bindings
  tk_bindForTraversal .top1.frame
  bind .top1.frame <F10> {tk_firstMenu %W} 
  bind .top1.frame <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .top1.frame.scrollbar1
  scrollbar .top1.frame.scrollbar1
  .top1.frame.scrollbar1 configure     -command {.top1.frame.text2 yview}    -width {10}
  # bindings
  tk_bindForTraversal .top1.frame.scrollbar1
  bind .top1.frame.scrollbar1 <F10> {tk_firstMenu %W} 
  bind .top1.frame.scrollbar1 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .top1.frame.text2
  text .top1.frame.text2
  .top1.frame.text2 configure     -borderwidth {1}    -exportselection {true}    -padx {2}    -pady {2}    -relief {raised}    -selectborderwidth {0}    -state {disabled}    -wrap {none}    -yscrollcommand {.top1.frame.scrollbar1 set}
  # bindings
  tk_bindForTraversal .top1.frame.text2
  bind .top1.frame.text2 <Next> {
      set xfCounter [lindex [%W config -height] 4]
      while {$xfCounter > 0} {
        %W mark set insert insert+1l
        incr xfCounter -1
      }
      %W yview -pickplace insert} 
  bind .top1.frame.text2 <Prior> {
      set xfCounter [lindex [%W config -height] 4]
      while {$xfCounter > 0} {
        %W mark set insert insert-1l
        incr xfCounter -1
      }
      %W yview -pickplace insert} 
  bind .top1.frame.text2 <End> {
      %W mark set insert end
      %W yview -pickplace insert} 
  bind .top1.frame.text2 <Home> {
      %W mark set insert 1.0
      %W yview -pickplace insert} 
  bind .top1.frame.text2 <Control-e> {
      %W mark set insert "insert lineend"
      %W yview -pickplace insert} 
  bind .top1.frame.text2 <Control-a> {
      %W mark set insert "insert linestart"
      %W yview -pickplace insert} 
  bind .top1.frame.text2 <Down> {
      %W mark set insert insert+1l
      %W yview -pickplace insert} 
  bind .top1.frame.text2 <Up> {
      %W mark set insert insert-1l
      %W yview -pickplace insert} 
  bind .top1.frame.text2 <Right> {
      %W mark set insert insert+1c
      %W yview -pickplace insert} 
  bind .top1.frame.text2 <Delete> {
      %W delete insert insert+1c
      %W yview -pickplace insert} 
  bind .top1.frame.text2 <Left> {
      %W mark set insert insert-1c
      %W yview -pickplace insert} 
  bind .top1.frame.text2 <Control-v> {
      %W insert insert "[GetSelection]"
      %W yview -pickplace insert} 
  bind .top1.frame.text2 <Any-Key> {NoFunction} 


  .top1.frame.text2 insert end {
                  Meta Schema Tool

`Meta Schema Tool' is so far a tool without a sensible help text.
}

  # pack widget .top1.frame
  pack append .top1.frame    .top1.frame.scrollbar1   {left frame center filly}     .top1.frame.text2   {top frame center expand fill} 


  # pack widget .top1
  pack append .top1    .top1.frame   {top frame center expand fill}     .top1.button5   {bottom frame center pady 4} 

  if {[string length [info commands .XFEdit]] > 0} {
    XFEditSetShowWindows
    XFMiscBindWidgetTree .top1
  }
}

proc DestroyWindow.top1 {} {
  if {[string length [info procs XFSaveAsProc]] > 0} {
    if {[string length [info commands .top1]] > 0} {
      XFMiscRemoveBindWidgetTree .top1 notall
      global xfShowWindow.top1
      set xfShowWindow.top1 0
      XFEditSetPath .
      after 200 "XFSaveAsProc .top1; XFEditSetShowWindows"
    }
  } {
    catch "destroy .top1"
    update
  }
}

proc ShowWindow.top7 { args} {

  # build widget .top7

  if {[string length [info commands .XFEdit]] > 0} {
    catch "XFDestroy .top7"
  } {
    catch "destroy .top7"
  }
  toplevel .top7
  .top7 configure     -relief {raised}
  # bindings
  tk_bindForTraversal .top7
  bind .top7 <F10> {tk_firstMenu %W} 
  bind .top7 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # Window manager configurations
  wm title .top7 {ViewParameter}
  wm positionfrom .top7 program
  wm sizefrom .top7 program
  wm maxsize .top7 1000 900
  wm minsize .top7 10 10

  # build widget .top7.frame9
  frame .top7.frame9
  .top7.frame9 configure     -geometry {30x46}
  # bindings
  tk_bindForTraversal .top7.frame9
  bind .top7.frame9 <F10> {tk_firstMenu %W} 
  bind .top7.frame9 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .top7.frame9.button11
  button .top7.frame9.button11
  .top7.frame9.button11 configure     -command {DestroyWindow[SymbolicName mta::ViewParamBox]}    -text {Close}    -width {9}
  # bindings
  tk_bindForTraversal .top7.frame9.button11
  bind .top7.frame9.button11 <F10> {tk_firstMenu %W} 
  bind .top7.frame9.button11 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # pack widget .top7.frame9
  pack append .top7.frame9    .top7.frame9.button11   {bottom frame center pady 20} 


  # build widget .top7.frame8
  frame .top7.frame8
  .top7.frame8 configure     -geometry {30x30}
  # bindings
  tk_bindForTraversal .top7.frame8
  bind .top7.frame8 <F10> {tk_firstMenu %W} 
  bind .top7.frame8 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .top7.frame8.frame12
  frame .top7.frame8.frame12
  .top7.frame8.frame12 configure     -borderwidth {2}    -geometry {30x30}
  # bindings
  tk_bindForTraversal .top7.frame8.frame12
  bind .top7.frame8.frame12 <F10> {tk_firstMenu %W} 
  bind .top7.frame8.frame12 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .top7.frame8.frame12.radiobutton14
  radiobutton .top7.frame8.frame12.radiobutton14
  .top7.frame8.frame12.radiobutton14 configure     -anchor {w}    -padx {2}    -text {methods}    -value {showMethods}    -variable {mta::_WhichElem1}    -width {11}
  # bindings
  tk_bindForTraversal .top7.frame8.frame12.radiobutton14
  bind .top7.frame8.frame12.radiobutton14 <F10> {tk_firstMenu %W} 
  bind .top7.frame8.frame12.radiobutton14 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .top7.frame8.frame12.radiobutton15
  radiobutton .top7.frame8.frame12.radiobutton15
  .top7.frame8.frame12.radiobutton15 configure     -anchor {w}    -padx {2}    -text {components}    -value {showComponents}    -variable {mta::_WhichElem1}    -width {11}
  # bindings
  tk_bindForTraversal .top7.frame8.frame12.radiobutton15
  bind .top7.frame8.frame12.radiobutton15 <F10> {tk_firstMenu %W} 
  bind .top7.frame8.frame12.radiobutton15 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .top7.frame8.frame12.radiobutton16
  radiobutton .top7.frame8.frame12.radiobutton16
  .top7.frame8.frame12.radiobutton16 configure     -anchor {w}    -padx {2}    -text {base classes}    -value {showBaseClasses}    -variable {mta::_WhichElem1}    -width {11}
  # bindings
  tk_bindForTraversal .top7.frame8.frame12.radiobutton16
  bind .top7.frame8.frame12.radiobutton16 <F10> {tk_firstMenu %W} 
  bind .top7.frame8.frame12.radiobutton16 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # pack widget .top7.frame8.frame12
  pack append .top7.frame8.frame12    .top7.frame8.frame12.radiobutton14   {top frame center padx 8 pady 8}     .top7.frame8.frame12.radiobutton15   {top frame center}     .top7.frame8.frame12.radiobutton16   {top frame center} 


  # build widget .top7.frame8.frame13
  frame .top7.frame8.frame13
  .top7.frame8.frame13 configure     -borderwidth {2}    -geometry {30x30}
  # bindings
  tk_bindForTraversal .top7.frame8.frame13
  bind .top7.frame8.frame13 <F10> {tk_firstMenu %W} 
  bind .top7.frame8.frame13 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .top7.frame8.frame13.radiobutton17
  radiobutton .top7.frame8.frame13.radiobutton17
  .top7.frame8.frame13.radiobutton17 configure     -anchor {w}    -padx {2}    -text {local}    -value {showLocals}    -variable {mta::_WhichElem2}    -width {5}
  # bindings
  tk_bindForTraversal .top7.frame8.frame13.radiobutton17
  bind .top7.frame8.frame13.radiobutton17 <F10> {tk_firstMenu %W} 
  bind .top7.frame8.frame13.radiobutton17 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .top7.frame8.frame13.radiobutton18
  radiobutton .top7.frame8.frame13.radiobutton18
  .top7.frame8.frame13.radiobutton18 configure     -anchor {w}    -padx {2}    -text {all}    -value {showAll}    -variable {mta::_WhichElem2}    -width {5}
  # bindings
  tk_bindForTraversal .top7.frame8.frame13.radiobutton18
  bind .top7.frame8.frame13.radiobutton18 <F10> {tk_firstMenu %W} 
  bind .top7.frame8.frame13.radiobutton18 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # pack widget .top7.frame8.frame13
  pack append .top7.frame8.frame13    .top7.frame8.frame13.radiobutton17   {top frame center padx 8 pady 8}     .top7.frame8.frame13.radiobutton18   {top frame center} 


  # pack widget .top7.frame8
  pack append .top7.frame8    .top7.frame8.frame12   {left frame center expand fill}     .top7.frame8.frame13   {right frame center expand fill} 


  # pack widget .top7
  pack append .top7    .top7.frame8   {top frame center expand fill}     .top7.frame9   {bottom frame center fillx} 

  if {[string length [info commands .XFEdit]] > 0} {
    XFEditSetShowWindows
    XFMiscBindWidgetTree .top7
  }
}

proc DestroyWindow.top7 {} {
  if {[string length [info procs XFSaveAsProc]] > 0} {
    if {[string length [info commands .top7]] > 0} {
      XFMiscRemoveBindWidgetTree .top7 notall
      global xfShowWindow.top7
      set xfShowWindow.top7 0
      XFEditSetPath .
      after 200 "XFSaveAsProc .top7; XFEditSetShowWindows"
    }
  } {
    catch "destroy .top7"
    update
  }
}

# contents of .
proc ShowWindow. {args} {

  # Window manager configurations
  wm title . {mtaTool.tcl}
  wm geometry . 400x300
  wm positionfrom . program
  wm sizefrom . user
  wm maxsize . 1152 900
  wm minsize . 0 0

  # build widget .frame0
  frame .frame0
  .frame0 configure \
    -borderwidth {1}\
    -geometry {30x30}\
    -relief {raised}
  # bindings
  tk_bindForTraversal .frame0
  bind .frame0 <F10> {tk_firstMenu %W} 
  bind .frame0 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame0.menubutton3
  menubutton .frame0.menubutton3
  .frame0.menubutton3 configure \
    -borderwidth {1}\
    -menu {.frame0.menubutton3.m}\
    -relief {raised}\
    -text {Objects}
  # bindings
  tk_bindForTraversal .frame0.menubutton3
  bind .frame0.menubutton3 <F10> {tk_firstMenu %W} 
  bind .frame0.menubutton3 <Mod2-Key> {tk_traverseToMenu %W %A} 

  tk_menus . .frame0.menubutton3

  # build widget .frame0.menubutton3.m
  menu .frame0.menubutton3.m
  .frame0.menubutton3.m configure 
  # bindings
  tk_bindForTraversal .frame0.menubutton3.m
  bind .frame0.menubutton3.m <F10> {tk_firstMenu %W} 
  bind .frame0.menubutton3.m <Mod2-Key> {tk_traverseToMenu %W %A} 

# Menu widget code
  .frame0.menubutton3.m add command\
  -command {ShowWindow.top7}\
  -label {View Parameter}
  .frame0.menubutton3.m add command\
  -command {destroy [SymbolicName root]}\
  -label {Quit}

  # build widget .frame0.menubutton4
  menubutton .frame0.menubutton4
  .frame0.menubutton4 configure \
    -borderwidth {1}\
    -menu {.frame0.menubutton4.m}\
    -relief {raised}\
    -text {Help}
  # bindings
  tk_bindForTraversal .frame0.menubutton4
  bind .frame0.menubutton4 <F10> {tk_firstMenu %W} 
  bind .frame0.menubutton4 <Mod2-Key> {tk_traverseToMenu %W %A} 

  tk_menus . .frame0.menubutton4

  # build widget .frame0.menubutton4.m
  menu .frame0.menubutton4.m
  .frame0.menubutton4.m configure 
  # bindings
  tk_bindForTraversal .frame0.menubutton4.m
  bind .frame0.menubutton4.m <F10> {tk_firstMenu %W} 
  bind .frame0.menubutton4.m <Mod2-Key> {tk_traverseToMenu %W %A} 

# Menu widget code
  .frame0.menubutton4.m add command\
  -command {mta::showInfo about}\
  -label {About ...}

  # pack widget .frame0
  pack append .frame0\
    .frame0.menubutton3   {left frame center filly} \
    .frame0.menubutton4   {right frame center filly} 


  # build widget .frame1
  frame .frame1
  .frame1 configure \
    -geometry {30x30}
  # bindings
  tk_bindForTraversal .frame1
  bind .frame1 <F10> {tk_firstMenu %W} 
  bind .frame1 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame1.frame5
  frame .frame1.frame5
  .frame1.frame5 configure \
    -geometry {30x30}
  # bindings
  tk_bindForTraversal .frame1.frame5
  bind .frame1.frame5 <F10> {tk_firstMenu %W} 
  bind .frame1.frame5 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame1.frame5.frame
  frame .frame1.frame5.frame
  .frame1.frame5.frame configure \
    -borderwidth {1}\
    -geometry {30x30}
  # bindings
  tk_bindForTraversal .frame1.frame5.frame
  bind .frame1.frame5.frame <F10> {tk_firstMenu %W} 
  bind .frame1.frame5.frame <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame1.frame5.frame.scrollbar3
  scrollbar .frame1.frame5.frame.scrollbar3
  .frame1.frame5.frame.scrollbar3 configure \
    -command {.frame1.frame5.frame.listbox1 xview}\
    -orient {horizontal}\
    -width {10}
  # bindings
  tk_bindForTraversal .frame1.frame5.frame.scrollbar3
  bind .frame1.frame5.frame.scrollbar3 <F10> {tk_firstMenu %W} 
  bind .frame1.frame5.frame.scrollbar3 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame1.frame5.frame.scrollbar2
  scrollbar .frame1.frame5.frame.scrollbar2
  .frame1.frame5.frame.scrollbar2 configure \
    -command {.frame1.frame5.frame.listbox1 yview}\
    -width {10}
  # bindings
  tk_bindForTraversal .frame1.frame5.frame.scrollbar2
  bind .frame1.frame5.frame.scrollbar2 <F10> {tk_firstMenu %W} 
  bind .frame1.frame5.frame.scrollbar2 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame1.frame5.frame.listbox1
  listbox .frame1.frame5.frame.listbox1
  .frame1.frame5.frame.listbox1 configure \
    -borderwidth {1}\
    -exportselection {false}\
    -geometry {10x2}\
    -relief {raised}\
    -xscrollcommand {.frame1.frame5.frame.scrollbar3 set}\
    -yscrollcommand {.frame1.frame5.frame.scrollbar2 set}
  # bindings
  tk_bindForTraversal .frame1.frame5.frame.listbox1
  bind .frame1.frame5.frame.listbox1 <Any-Button-1> {mta::listbox_cb %W mta::selectSchema %y} 
  bind .frame1.frame5.frame.listbox1 <F10> {tk_firstMenu %W} 
  bind .frame1.frame5.frame.listbox1 <Mod2-Key> {tk_traverseToMenu %W %A} 



  # pack widget .frame1.frame5.frame
  pack append .frame1.frame5.frame\
    .frame1.frame5.frame.scrollbar2   {left frame center filly} \
    .frame1.frame5.frame.listbox1   {top frame center expand fill} \
    .frame1.frame5.frame.scrollbar3   {bottom frame center fillx} 


  # build widget .frame1.frame5.frame6
  frame .frame1.frame5.frame6
  .frame1.frame5.frame6 configure \
    -borderwidth {1}\
    -geometry {30x30}
  # bindings
  tk_bindForTraversal .frame1.frame5.frame6
  bind .frame1.frame5.frame6 <F10> {tk_firstMenu %W} 
  bind .frame1.frame5.frame6 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame1.frame5.frame6.scrollbar3
  scrollbar .frame1.frame5.frame6.scrollbar3
  .frame1.frame5.frame6.scrollbar3 configure \
    -command {.frame1.frame5.frame6.listbox1 xview}\
    -orient {horizontal}\
    -width {10}
  # bindings
  tk_bindForTraversal .frame1.frame5.frame6.scrollbar3
  bind .frame1.frame5.frame6.scrollbar3 <F10> {tk_firstMenu %W} 
  bind .frame1.frame5.frame6.scrollbar3 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame1.frame5.frame6.scrollbar2
  scrollbar .frame1.frame5.frame6.scrollbar2
  .frame1.frame5.frame6.scrollbar2 configure \
    -command {.frame1.frame5.frame6.listbox1 yview}\
    -width {10}
  # bindings
  tk_bindForTraversal .frame1.frame5.frame6.scrollbar2
  bind .frame1.frame5.frame6.scrollbar2 <F10> {tk_firstMenu %W} 
  bind .frame1.frame5.frame6.scrollbar2 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame1.frame5.frame6.listbox1
  listbox .frame1.frame5.frame6.listbox1
  .frame1.frame5.frame6.listbox1 configure \
    -borderwidth {1}\
    -exportselection {false}\
    -geometry {20x2}\
    -relief {raised}\
    -xscrollcommand {.frame1.frame5.frame6.scrollbar3 set}\
    -yscrollcommand {.frame1.frame5.frame6.scrollbar2 set}
  # bindings
  tk_bindForTraversal .frame1.frame5.frame6.listbox1
  bind .frame1.frame5.frame6.listbox1 <Any-Button-1> {mta::listbox_cb %W mta::selectType %y} 
  bind .frame1.frame5.frame6.listbox1 <F10> {tk_firstMenu %W} 
  bind .frame1.frame5.frame6.listbox1 <Mod2-Key> {tk_traverseToMenu %W %A} 



  # pack widget .frame1.frame5.frame6
  pack append .frame1.frame5.frame6\
    .frame1.frame5.frame6.scrollbar2   {left frame center filly} \
    .frame1.frame5.frame6.listbox1   {top frame center expand fill} \
    .frame1.frame5.frame6.scrollbar3   {bottom frame center fillx} 


  # pack widget .frame1.frame5
  pack append .frame1.frame5\
    .frame1.frame5.frame   {left frame center expand fill} \
    .frame1.frame5.frame6   {right frame center expand fill} 


  # build widget .frame1.frame
  frame .frame1.frame
  .frame1.frame configure \
    -borderwidth {1}\
    -geometry {30x30}
  # bindings
  tk_bindForTraversal .frame1.frame
  bind .frame1.frame <F10> {tk_firstMenu %W} 
  bind .frame1.frame <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame1.frame.scrollbar3
  scrollbar .frame1.frame.scrollbar3
  .frame1.frame.scrollbar3 configure \
    -command {.frame1.frame.listbox1 xview}\
    -orient {horizontal}\
    -width {10}
  # bindings
  tk_bindForTraversal .frame1.frame.scrollbar3
  bind .frame1.frame.scrollbar3 <F10> {tk_firstMenu %W} 
  bind .frame1.frame.scrollbar3 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame1.frame.scrollbar2
  scrollbar .frame1.frame.scrollbar2
  .frame1.frame.scrollbar2 configure \
    -command {.frame1.frame.listbox1 yview}\
    -width {10}
  # bindings
  tk_bindForTraversal .frame1.frame.scrollbar2
  bind .frame1.frame.scrollbar2 <F10> {tk_firstMenu %W} 
  bind .frame1.frame.scrollbar2 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame1.frame.listbox1
  listbox .frame1.frame.listbox1
  .frame1.frame.listbox1 configure \
    -borderwidth {1}\
    -exportselection {false}\
    -geometry {15x2}\
    -relief {raised}\
    -xscrollcommand {.frame1.frame.scrollbar3 set}\
    -yscrollcommand {.frame1.frame.scrollbar2 set}
  # bindings
  tk_bindForTraversal .frame1.frame.listbox1
  bind .frame1.frame.listbox1 <Any-Button-1> {mta::listbox_cb %W mta::selectElem %y} 
  bind .frame1.frame.listbox1 <F10> {tk_firstMenu %W} 
  bind .frame1.frame.listbox1 <Mod2-Key> {tk_traverseToMenu %W %A} 



  # pack widget .frame1.frame
  pack append .frame1.frame\
    .frame1.frame.scrollbar2   {left frame center filly} \
    .frame1.frame.listbox1   {top frame center expand fill} \
    .frame1.frame.scrollbar3   {bottom frame center fillx} 


  # pack widget .frame1
  pack append .frame1\
    .frame1.frame5   {left frame center expand fill} \
    .frame1.frame   {right frame center expand fill} 


  # build widget .frame2
  frame .frame2
  .frame2 configure \
    -geometry {30x30}
  # bindings
  tk_bindForTraversal .frame2
  bind .frame2 <F10> {tk_firstMenu %W} 
  bind .frame2 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame2.frame
  frame .frame2.frame
  .frame2.frame configure \
    -borderwidth {1}\
    -geometry {30x30}\
    -relief {raised}
  # bindings
  tk_bindForTraversal .frame2.frame
  bind .frame2.frame <F10> {tk_firstMenu %W} 
  bind .frame2.frame <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame2.frame.scrollbar1
  scrollbar .frame2.frame.scrollbar1
  .frame2.frame.scrollbar1 configure \
    -command {.frame2.frame.text2 yview}\
    -width {10}
  # bindings
  tk_bindForTraversal .frame2.frame.scrollbar1
  bind .frame2.frame.scrollbar1 <F10> {tk_firstMenu %W} 
  bind .frame2.frame.scrollbar1 <Mod2-Key> {tk_traverseToMenu %W %A} 


  # build widget .frame2.frame.text2
  text .frame2.frame.text2
  .frame2.frame.text2 configure \
    -borderwidth {1}\
    -exportselection {true}\
    -height {5}\
    -padx {2}\
    -pady {2}\
    -relief {raised}\
    -yscrollcommand {.frame2.frame.scrollbar1 set}
  # bindings
  tk_bindForTraversal .frame2.frame.text2
  bind .frame2.frame.text2 <Any-Key> {NoFunction} 
  bind .frame2.frame.text2 <Control-v> {
      %W insert insert "[GetSelection]"
      %W yview -pickplace insert} 
  bind .frame2.frame.text2 <Left> {
      %W mark set insert insert-1c
      %W yview -pickplace insert} 
  bind .frame2.frame.text2 <Delete> {
      %W delete insert insert+1c
      %W yview -pickplace insert} 
  bind .frame2.frame.text2 <Right> {
      %W mark set insert insert+1c
      %W yview -pickplace insert} 
  bind .frame2.frame.text2 <Up> {
      %W mark set insert insert-1l
      %W yview -pickplace insert} 
  bind .frame2.frame.text2 <Down> {
      %W mark set insert insert+1l
      %W yview -pickplace insert} 
  bind .frame2.frame.text2 <Control-a> {
      %W mark set insert "insert linestart"
      %W yview -pickplace insert} 
  bind .frame2.frame.text2 <Control-e> {
      %W mark set insert "insert lineend"
      %W yview -pickplace insert} 
  bind .frame2.frame.text2 <Home> {
      %W mark set insert 1.0
      %W yview -pickplace insert} 
  bind .frame2.frame.text2 <End> {
      %W mark set insert end
      %W yview -pickplace insert} 
  bind .frame2.frame.text2 <Prior> {
      set xfCounter [lindex [%W config -height] 4]
      while {$xfCounter > 0} {
        %W mark set insert insert-1l
        incr xfCounter -1
      }
      %W yview -pickplace insert} 
  bind .frame2.frame.text2 <Next> {
      set xfCounter [lindex [%W config -height] 4]
      while {$xfCounter > 0} {
        %W mark set insert insert+1l
        incr xfCounter -1
      }
      %W yview -pickplace insert} 


  .frame2.frame.text2 insert end {}

  # pack widget .frame2.frame
  pack append .frame2.frame\
    .frame2.frame.scrollbar1   {left frame center filly} \
    .frame2.frame.text2   {top frame center fill} 


  # pack widget .frame2
  pack append .frame2\
    .frame2.frame   {top frame center fillx} 

  # bindings
  tk_bindForTraversal .
  bind . <F10> {tk_firstMenu %W} 
  bind . <Mod2-Key> {tk_traverseToMenu %W %A} 


  # pack widget .
  pack append .\
    .frame0   {top frame center fillx} \
    .frame1   {top frame center expand fill} \
    .frame2   {top frame center fillx} 

  if {[string length [info commands .XFEdit]] > 0} {
    XFEditSetShowWindows
    XFMiscBindWidgetTree .frame2
  }
}


# Procedures


if {[string length [info procs GetSelection]] == 0} {
proc GetSelection {} {

  # the save way
  set xfSelection ""
  catch "selection get" xfSelection
  return $xfSelection
}
}


if {[string length [info procs SymbolicName]] == 0} {
proc SymbolicName { {xfName ""}} {
  global symbolicName

  if {[string length $xfName] > 0} {
    set xfArrayName ""
    append xfArrayName symbolicName ( $xfName )
    if {[catch "set \"$xfArrayName\"" xfValue] == 0} {
      return $xfValue
    } {
      if {[string length [info commands XFError]] > 0} {
        XFError "Unknown symbolic name:\n$xfName"
      } {
        puts stderr "XF error: unknown symbolic name:\n$xfName"
      }
    }
  }
  return ""
}
}

proc tkerror { err} {
    global errorInfo
    puts stdout "$errorInfo"
}


if {[string length [info procs NoFunction]] == 0} {
proc NoFunction { args} {

}
}


if {[string length [info procs MenuPopupHandle]] == 0} {
proc MenuPopupHandle { xfMenu xfW xfX xfY} {

 if {[winfo ismapped $xfMenu]} {
   set xfPopMinX [winfo rootx $xfMenu]
   set xfPopMaxX [expr "$xfPopMinX + [winfo width $xfMenu]"]
   if {($xfX >= $xfPopMinX) &&  ($xfX <= $xfPopMaxX)} {
     $xfMenu activate @[expr "$xfY - [winfo rooty $xfMenu]"]
   } {
     $xfMenu activate none}
   }
}
}

if {[string length [info procs MenuPopupAdd]] == 0} {
proc MenuPopupAdd { xfW xfButton xfMenu} {

  if {[catch "bind $xfW \"<ButtonPress-$xfButton>\"                 \"$xfMenu post %X %Y\"" xfResult] != 0} {
    XFError "Could not bind popup menu to widget.\nI got:\n$xfResult"
    return
  }
  # we need these to counteract the effects of passive grabs :-(
  if {[catch "bind $xfW \"<ButtonRelease-$xfButton>\"                 \"$xfMenu invoke active; $xfMenu unpost\"" xfResult] != 0} {
    XFError "Could not bind popup menu to widget.\nI got:\n$xfResult"
    return
  }
  if {[catch "bind $xfW \"<B$xfButton-Motion>\"                 \"MenuPopupHandle $xfMenu %W %X %Y\"" xfResult] != 0} {
    XFError "Could not bind popup menu to widget.\nI got:\n$xfResult"
    return
  }
}
}


if {[string length [info procs EntryV2C]] == 0} {
proc EntryV2C { xfW} {

  set xfLeftExtent [$xfW index @0]
  set xfRightExtent [$xfW index @[winfo width $xfW]]
  set xfCursorPos [$xfW index cursor]
  set xfEntryLen [expr "$xfRightExtent-$xfLeftExtent"]

  if {$xfCursorPos > $xfLeftExtent} {
    if {$xfCursorPos > $xfRightExtent} {
      #handle cursor too far to the right
      $xfW view [expr "$xfCursorPos-$xfEntryLen+1"]
    }
  } { 
    #handle cursor too far to the left
    $xfW view [expr "$xfCursorPos-1"]
  }
}
}



if {[string length [info procs EntryBS]] == 0} {
proc EntryBS { xfW} {

  set xfX [expr {[$xfW index cursor]-1}]
  if {$xfX != -1} {
    $xfW delete $xfX
  }
  EntryV2C $xfW
}
}


proc mta::listbox_cb { box select_handler ypos} {
#-------------------
set Index [$box nearest $ypos]

$select_handler $Index
}

proc mta::showInfo { what {text ""}} {
#-----------------
global errorInfo

if {[info exists errorInfo]} then {
   set errInfo $errorInfo
} else {
   set errInfo ""
}
set Box     [SymbolicName mta::InfoBox]
set TextBox [SymbolicName mta::InfoTextBox]

if {[catch "winfo ismapped Box"]} ShowWindow$Box

$TextBox configure -state normal
$TextBox delete 1.0 end

case $what in {
  error {$TextBox insert end "$errInfo"}
  text  {$TextBox insert end "$text"}
  about {$TextBox insert end {
                  Meta Schema Tool

`Meta Schema Tool' is a simple tool which lets you
browse the OBST meta database in a hierarchical
fashion.

Three abstraction levels are supported:
 - schema
 - type
 - type details

These three abstraction levels are mirrored by three
list which display from left to right:
 - all currently known schemata
 - all types (except for generic classes) in the
   selected schema
 - details concerning the currently selected type

There is furthermore a text field at the bottom which
holds additional information about the current
selection:
 - The size of an external type.
 - The type named by a typedef.
 - The sequence number of an enumeration literal.
 - The types subsumed by an union type.
 - Method signatures for a class type.

Selections are performed by clicking on the respective
list entry. The lists to the right as well as the text
field will then be redisplayed.

The display of a class type can be further tailored
after activating 'View Parameter' from the 'Objects'
menu.
It is possible to either select methods, components,
or base classes, as well as to restrict the display
to just the local details, respectively to just the
direct base classes.

In case of components, the method signatures of the
accessor methods will be displayed in the text box.
A missing accessor method means that the respective
component is defined in a base class and that this
accessor method is a private one.
	}}
}
$TextBox configure -state disabled
}

proc mta::showSchemaDir {} {
#----------------------
global mta::SchemaDir

set Box 	   [SymbolicName mta::SchemaListBox]
set mta::SchemaDir [mcall sos_Schema_module::schema_dir]

$Box delete 0 end

set SchemaList ""
agg loop ${mta::SchemaDir} {
   lappend SchemaList [[agg current role1] make_Cstring]
}
foreach Schema [lsort $SchemaList] {
   $Box insert end $Schema
}
$Box yview 0

mta::selectSchema 0
}

proc mta::name { obj} {
#-------------
return [[$obj get_name] make_Cstring]
}

proc mta::method_name { method} {
#--------------------
if {[$method get_is_operator] == "TRUE"} then {
   return "operator[mta::name $method]"
} else {
   return "[mta::name $method]/[agg card [$method get_params]]"
}
}

proc mta::showUnionType {} {
#-----------------------
global mta::CurrentType

set ElemBox [SymbolicName mta::ElemListBox]

agg loop [${mta::CurrentType} get_united] {
   lappend UnionList [mta::name [agg current]]
}
foreach UnionType [lsort $UnionList] {
   $ElemBox insert end [mta::name [agg current]]
}
}

proc mta::selectSchema { index} {
#---------------------
global mta::SchemaDir mta::CurrentTypeTbl

set SchemaBox 	        [SymbolicName mta::SchemaListBox]

if {$index >= [$SchemaBox size]} then return

set TypeBox   	        [SymbolicName mta::TypeListBox]
set SchemaNm  	        [OBST tmpstr [$SchemaBox get $index]]
set mta::CurrentTypeTbl [[${mta::SchemaDir} {[]} $SchemaNm] get_type_table]

$SchemaNm destroy

$TypeBox delete 0 end
$SchemaBox select from $index

set TypeList ""
agg loop ${mta::CurrentTypeTbl} {
   if {[OBST has_type [agg current role2] sos_Class_type]
       && [[agg current role2] is_generic_class] == "TRUE"} then continue

   lappend TypeList [[agg current role1] make_Cstring]
}
foreach Type [lsort $TypeList] {
   $TypeBox insert end $Type
}
$TypeBox yview 0

mta::selectType 0
}

proc mta::showTypedefType {} {
#-----------------------
global mta::CurrentType

set TextBox [SymbolicName mta::TextBox]

$TextBox configure -state normal
$TextBox insert end "refers to: [mta::name [${mta::CurrentType} make_type]]\n"
$TextBox configure -state disabled
}

proc mta::selectType { index} {
#-------------------
global mta::WhichElem1 mta::WhichElem2 mta::_WhichElem1 mta::_WhichElem2 \
       mta::CurrentTypeTbl mta::CurrentType

set TypeBox 	     [SymbolicName mta::TypeListBox]

if {$index >= [$TypeBox size]} then return

set ElemBox 	     [SymbolicName mta::ElemListBox]
set TextBox	     [SymbolicName mta::TextBox]
set TypeNm	     [OBST tmpstr [$TypeBox get $index]]
set mta::CurrentType [${mta::CurrentTypeTbl} {[]} $TypeNm]

$TypeNm destroy

$TypeBox select from $index
$ElemBox delete 0 end

$TextBox configure -state normal
$TextBox delete 1.0 end
$TextBox configure -state disabled

set mta::WhichElem1 ${mta::_WhichElem1}
set mta::WhichElem2 ${mta::_WhichElem2}

case [mta::name [${mta::CurrentType} type]] in {
   sos_Extern_type  {mta::showExternType}
   sos_Enum_type    {mta::showEnumType}
   sos_Union_type   {mta::showUnionType}
   sos_Typedef_type {mta::showTypedefType}
   sos_Class_type   {mta::showClassType}
}
$ElemBox yview 0

mta::selectElem 0
}

proc mta::showClassType {} {
#----------------------
global mta::WhichElem1 mta::WhichElem2 mta::CurrentType 

set ElemBox 	  [SymbolicName mta::ElemListBox]
set show_all	  [expr {${mta::WhichElem2} == "showAll"}]
set ClassElemList ""

case ${mta::WhichElem1} in {
   showMethods {
      agg loop [${mta::CurrentType} get_methods] {
	 agg loop [agg current role2] {
	    if {$show_all ||
		[[[agg current] get_defined_in] root] == ${mta::CurrentType}} {
	       lappend ClassElemList [mta::method_name [agg current]]
      }}}}
   showComponents {
      agg loop [${mta::CurrentType} get_components] {
	 if {$show_all} then {
	    lappend ClassElemList [mta::name [agg current]]
	 } else {
	    set rclass [[[[agg current] get_get_method] get_defined_in] root]
	    if {$rclass == ${mta::CurrentType}} {
	       lappend ClassElemList [mta::name [agg current]]
	    }
      }}}
   showBaseClasses {
      agg loop [${mta::CurrentType} get_super_closure] {
	 set class [[[agg current] get_super_class] make_type]

	 if {$class != ${mta::CurrentType}
	     && ($show_all || [[agg current] get_is_direct] == "TRUE")} {
	    lappend ClassElemList [mta::name $class]
      }}}
}

foreach Elem [lsort $ClassElemList] {
   $ElemBox insert end $Elem
}
}

proc mta::showEnumType {} {
#-----------------------
global mta::CurrentType

set ElemBox [SymbolicName mta::ElemListBox]

agg loop [${mta::CurrentType} get_literals] {
   lappend LiteralList [[agg current] make_Cstring]
}
foreach Literal [lsort $LiteralList] {
   $ElemBox insert end $Literal
}
}

proc mta::showExternType {} {
#-----------------------
global mta::CurrentType

set TextBox [SymbolicName mta::TextBox]

$TextBox configure -state normal
$TextBox insert end "size: [${mta::CurrentType} get_object_size] bytes\n"
$TextBox configure -state disabled
}

proc mta::selectElem { index} {
#-------------------
global mta::CurrentType mta::WhichElem1

set ElemBox [SymbolicName mta::ElemListBox]

if {$index >= [$ElemBox size]} then return

set TextBox [SymbolicName mta::TextBox]
set Elem    [$ElemBox get $index]

$ElemBox select from $index
$TextBox configure -state normal

case [mta::name [${mta::CurrentType} type]] in {
   sos_Enum_type {
      set idx 1
      agg loop [${mta::CurrentType} get_literals] {
	 if {[[agg current] make_Cstring] == $Elem} break
	 set idx [expr {$idx + 1}]
      }
      $TextBox delete 1.0 end
      $TextBox insert end "enumeration index: $idx\n"
   }
   sos_Class_type {
      case ${mta::WhichElem1} in {
         showMethods {
	    $TextBox delete 1.0 end
	    set pcard -1
	    if {![regexp {operator([^A-Za-z_].*)} "$Elem" dummy mname]} {
	       regexp "(.*)/(.*)" "$Elem" dummy mname pcard
            }
	    $TextBox delete 1.0 end
            $TextBox insert end "[mta::method_signature $mname $pcard]\n"
	 }
	 showComponents {
	    $TextBox delete 1.0 end
	    $TextBox insert end "[mta::method_signature get_$Elem 0]\n"
	    $TextBox insert end "[mta::method_signature set_$Elem 1]\n"
	 }
   }}
}

$TextBox configure -state disabled
}

proc mta::method_signature { mname pcard} {
#----------------------
global mta::CurrentType

set method  ""
set nameStr [OBST tmpstr $mname]
set mlist   [[${mta::CurrentType} get_methods] {[]} $nameStr]
$nameStr destroy

if {[agg card $mlist] == 1} then {
   set method [$mlist get_nth 1]
} else {
   agg loop $mlist {
      if {[agg card [[agg current] get_params]] == $pcard} {
	 set method [agg current]
	 break
   }}
}
if {$method == ""} then return

case [$method get_kind] in {
   sos_PUBLIC    {set result "public: "}
   sos_PROTECTED {set result "protected: "}
   sos_PRIVATE   {set result "private: "}
}
if {[$method get_is_static]   == "TRUE"} {set result "${result}static "  }
if {[$method get_is_definite] == "TRUE"} {set result "${result}definite "}
if {[$method get_is_abstract] == "TRUE"} {set result "${result}abstract "}
if {[$method get_is_operator] == "TRUE"} {set result "${result}operator" }
set result "${result}[mta::name $method] ("

set add_comma 0
agg loop [$method get_params] {
   if {$add_comma} then {
      set result "${result}, "
   } else {
      set add_comma 1
   }
   set result "${result}[mta::name [[[agg current] get_type] make_type]]"
   if {[[agg current] get_is_ref] == "TRUE"} {set result "${result}&"}
}
return "$result)"
}

# end source
proc EndSrc {} {
#----------
tclOBST bind

mta::showSchemaDir
}


# initialize global variables
# remove this call if there are problems at startup
InitGlobals


# stuff to display and remove toplevel windows
# call the procedures to create the toplevels.
ShowWindow.

global xfShowWindow.top1
set xfShowWindow.top1 0

global xfShowWindow.top7
set xfShowWindow.top7 0

# end source

#----------
tclOBST bind

mta::showSchemaDir


# eof
#
