# --------------------------------------------------------------------------
# Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
# All rights reserved.
#
# You can use and distribute this software under the terms of the license
# you should have received along with this software; either version 1.1 of
# the license, or (at your option) any later version.
# For a copy of the license or for additional information about this software,
# write to Xcc Software, Durlacher Allee 53, D-76131 Karlsruhe, Germany;
# Email: obst@xcc-ka.de.
# --------------------------------------------------------------------------

#
# This file contains some randomly collected code examples that are in
# particular intended for explaing some of the customization facilities of
# tclOBST.
# It may be used as follows: start up a tclOBST interpreter and cut&paste the
# contents of this file to execute the commands contained herein step by step.
#

#
# The running example from the 'The design ...' document.
#
proc example_loop {} {
   agg loop [mcall sos_Schema_module::schema_dir] {
      puts stdout "\t[[[agg current role2] get_name] make_Cstring]"
   }
}

#
# Print the contents of any collection...
#
proc print_collection {collection} {
   puts stdout "\ncardinality: [agg card $collection]"
   agg loop $collection {
       puts stdout "\t[agg current]"
   }
}

#
# first step: complete initialization
#
tclOBST bind

#
# Toying around with some temporary collections...
#

# -------- abbreviations, default arguments, and object representations ----

## get OBST constant, no abbreviations ...
set tmpCnt [OBST const TEMP_CONTAINER]
# ... same, but use abbreviations ...
set tmpCnt [OBST c T]
# oops - this should now work!
set tmpCnt [OBST c TE]

# Create temporary set, specify all arguments ...
set intSet [mcall sos_Int_Set::create $tmpCnt FALSE FALSE AGG_AUTOMATIC]
# ... destroy it ...
$intSet destroy
# ... and create it again, using default arguments.
set intSet [mcall sos_Int_Set::create $tmpCnt]

# Turn defaults off.
tclOBST customize allow_defaults false

# Create another kind of aggregate ...
set objBag [mcall sos_Object_Bag::create $tmpCnt]
# ... forgot that defaults are no longer allowed, so do it the long way ...
set objBag [mcall sos_Object_Bag::create $tmpCnt FALSE FALSE AGG_AUTOMATIC]

# Let's see, what we have so far...
print_collection $intSet
print_collection $objBag

# Now perform some insertions ...
$intSet insert 1
$intSet insert 1
$intSet insert 2
$objBag insert 1
# Ok, so we have to use the object representation instead
# (this is an object bag, no integer set).
$objBag insert [OBST s 1 sos_Int]

# Turn abbreviations off, so ...
tclOBST customize allow_abbrevs false
# ...
$objBag insert [OBST s 2 sos_Int]
# ... we have to use the full option name
$objBag insert [OBST scalar2obj 2 sos_Int]

# This is were we arrived at ...
print_collection $intSet
print_collection $objBag

# Clean up ...
$intSet destroy
$objBag destroy

# -------- eager binding vs. lazy binding ------------------------------------

# Now, just to make life more complicated, let's turn off eager binding ...
tclOBST customize object_as_command false
# To show any difference, we need an object first. So, why not a string...
set str [OBST tmpstr example]

# Since eager binding was turned off, we can now longer simply write...
$str get_length
# ... since this would require a binding for $str which is currently missing...
info commands $str

# One possibility is to use the mcall-form of command invocation ...
mcall $str get_length

# Another possibility is to use the lazy_bind module ...
source ./lib/tcl/lazy_bind.tcl
#(you might have to use 'source ./sample/lib/tcl/lazy_bind.tcl', instead)

# ... which will then transparently execute `tclOBST bind $str' for us.
# So, the following
$str get_length
# ... does now work again and we do now have a binding for $str as ...
info commands $str
# ... shows.

# -------- triggers ----------------------------------------------------------

# The first examples are triggers which do not use information from the
# called method...
tclOBST trigger before sos_String get_length 0 {puts stdout before}
tclOBST trigger after  sos_String get_length 0 {puts stdout after}
# ... let's see ...
$str get_length

# Ok, let's get rid of one of these triggers ...
tclOBST trigger after sos_String get_length 0 {}

# Besides before and after actions, we may also override the actual method ...
tclOBST trigger instead sos_String get_length 0 {return 1}

$str get_length

# ... but in that case, we have to provide the right type of return data ...
tclOBST trigger instead sos_String get_length 0 {return "I'm no number"}
# ... the following will hence fail
$str get_length

# More interesting applications require access to the original method and its
# arguments. First, let's print out the arguments ...
tclOBST trigger before sos_String assign_Cstring 1 {
   puts stdout "\
(obj: [tclOBST trigger current receiver])\
(argc: [tclOBST trigger current argc])\
(argv: [tclOBST trigger current argv])"
}

# ... we might also have used '[tclOBST trigger current argv 0]' to explicitly
# access the first argument, but let's use the above ...
$str assign_Cstring EXAMPLE

# Well, that's fine, but what if we want to call the original method?
# Say we want to change the argument list. ...

# No problem: let's use that executing triggers are automatically inactivated.
# Therefore, calling the method again calls the original implementation.

# So, we need an 'instead' action to overwrite the method and invoke the
# original method with changed argument inside the action code ...
tclOBST trigger instead sos_String assign_Cstring 1 {
   [tclOBST trig cur rec] assign_Cstring "-->[tclOBST trig cur argv 0]<--"
}

# Let's see ...
$str assign_Cstring EXAMPLE
# ... *&(#!$&!(@#&(!*#@ - ok, let's turn on abbreviations again ...
tclOBST customize allow_abbrevs TRUE
# ... but now ...
$str assign_Cstring EXAMPLE

# Hmm, either you believe blindly in what you've done...

# ... or, you really want to see it ...
$str make_Cstring

# Beside's modifying arguments we may also want to modify the result ...
tclOBST trigger instead sos_String get_length 0 {
   return [expr {[[tclOBST trig cur rec] get_length] + 1000}]
}

# ... yes, we've finally completely messed up the sos_String class ...
$str get_length


# ----------------------------------------------------------------------------

# ... and now, it's up to you to figure out some useful tclOBST code!
