# --------------------------------------------------------------------------
# Copyright 1994 by Forschungszentrum Informatik (FZI)
# All rights reserved.
#
# You can use and distribute this software under the terms of the license
# you should have received along with this software; either version 1.1 of
# the license, or (at your option) any later version.
# For a copy of the license or for additional information about this software,
# write to Xcc Software, Durlacher Allee 53, D-76131 Karlsruhe, Germany;
# Email: obst@xcc-ka.de.
# --------------------------------------------------------------------------

# Minitiature (well, it started as such) example for arrows module.
# Invoke by '<myWish> -f <this file>'.
#
source ./lib/tcl/arrows.tcl

canvas .c
pack .c

set n1 [.c create rect 150  10 160  30 -fill white]
set n2 [.c create rect  10  10  30  20 -fill white]
set n3 [.c create rect  80  30  90  40 -fill white]
set n4 [.c create oval 100 100 130 110 -fill white]

# -------- This is basically all you have to do with arrows
#   	   to get nodes and edges managed.
#
# Register nodes with arrows
#
arr_Node_add .c $n1
arr_Node_add .c $n2
arr_Node_add .c $n3
arr_Node_add .c $n4 new oval

# Define a few edges
#
arr_Edge_create .c $n1 $n2 bidir
arr_Edge_create .c $n1 $n3
arr_Edge_create .c $n2 $n3 unidir
arr_Edge_create .c $n4 $n2 nodir
#
# --------


#	
# Dragging nodes is done by a global canvas binding
# (The code is complicated by the fact that as well the canvas
#  binding as the node binding will trigger when a node is clicked at.
#
#  Hence, $Nd is used to record if a specific node is currently selected and
#  either the single or the multiple nodes dragging is selected at startup
#  (both modes are just used for demonstration purposes - a single node can
#   of course also be dragged in the multiple nodes dragging mode).
#
#  If we were to use just single node dragging, we might want to set up
#  just the following bindings for each node in the loop below (and forget
#  about the canvas bindings):
#	.c bind $node <ButtonPress-1> "arr_Drag init %W %x %y $node"
#	.c bind $node <B1-Motion>     "arr_Drag move %W %x %y"
#
#  If we were to use just multiple node dragging, we could remove the
#  node bindings for Button 1, remove the if command from the canvas binding,
#  and use just the set Nds in the canvas bindings.
# )
#
foreach node [list $n1 $n2 $n3 $n4] {
   .c bind $node <ButtonPress-1>   "set Nd $node"
   .c bind $node <ButtonRelease-1> "set Nd {}"

   .c bind $node <2> "arr_Set Nds insert $node; .c item $node -fill black"
   .c bind $node <3> "arr_Set Nds remove $node; .c item $node -fill white"
}
bind .c <ButtonPress-1>   {arr_Drag init %W %x %y \
				    	 [expr {($Nd == "") ? "Nds" : $Nd}]}
bind .c <B1-Motion>       {arr_Drag move %W %x %y}
bind .c <ButtonRelease-1> {arr_Drag done %W}

# Empty set of dragged nodes initially;
# record that no node is currently pointed at.
#
arr_Set Nds all {}
set Nd ""


# You can now drag the nodes with the left mouse button: Pointing on a specific
# node drags just that node, pointing on the background drags all currently
# selected nodes.
# Nodes are added to the set of dragged nodes with the middle button, and
# they are removed from that set with the right mouse button. Nodes in that
# set are painted black.
