##############################################################################
#
# demo.tcl: demonstrates how to use tclgdbm.tcl
#
# VERSION: 0.1
# 
# NOTE: to use this package, you will need either a tclsh which supports
#       gdbm commands or a Tcl version >= 7.5 and a dynamic library 
#       libtclgdbm-0.1.so.
#       It should also work with ndbm, though this is not tested
#
# You can get a package of "tcl+gdbm" from:
#        ftp://ftp.neosoft.com/pub/tcl/alcatel/extensions/tcl+gdbm-0.1.tar.gz
#
# and a package of "tcl+ndbm" from:
#        ftp://ftp.neosoft.com/pub/tcl/alcatel/extensions/tcl+ndbm-0.1.tar.gz
#
#
#
##############################################################################
#
# Copyright (C) 1997  Mario Weilguni <mweilguni@sime.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
##############################################################################

if {[catch { source [file join [file dirname [info script]] tcl_gdbm_wrapper.tcl]}]} {
    puts stderr "[info script]: cannot find tclgdbm.tcl"
    exit 1
}

# attach the array "names" to the database demo.db
# and create it if it does not exists.
puts "Opening database"
if {[dbm_attach "demo.db" "rwc" names] == 0} {
    puts stderr "[info script]: error when attaching array"
    exit 1
}
puts "\tarray \"names\" attached to database \"test.db\""

# from now on, every read access to "names" will result in a
# database access, and every write access will cause the
# changed value to be written to the database
#
# lets test it now
puts "Setting up a few array entries"
foreach i { {Mario Weilguni} {Erwin Schrdinger} {Otto Waalkes} \
		{Mark Knopfler} {Dalai Lama} {Bill Clinton} \
		{Franz Vranitzky} {{Wolfgang "Mascherl"} Schssel}} {
    set names([lindex $i 0]) [lindex $i 1]
    puts "\tWRITING: NAME=[lindex $i 0]\t\tLAST NAME=[lindex $i 1]"
}

# now close the database and forget the array
puts "Closing database"
dbm_unattach names 0

# the array "names" is already unset, but let's do it again to be safe
puts "Destroying array \"names\""
catch { unset names }

# reopen the database under a different name
puts "Opening database"
if {[dbm_attach "demo.db" "rwc" new_names] == 0} {
    puts stderr "[info script]: error when attaching array"
    exit 1
}
puts "\tarray \"new_names\" attached to database \"test.db\""

# increase the cache entries (makes no sense here, but when accessing
# a lot of different array entries, this can speed things up)
# From now on, up to 100 array entries are kept in memory
puts "Increasing cache size for array \"new_names\""
dbm_setcache new_names 100

# lets try it 
puts "List all indices from array \"new_names\""
puts -nonewline "\tKEYS found: "
foreach i [array names new_names] {
    puts -nonewline " $i "
}
puts ""

puts "List all array entries"
foreach i [array names new_names] {
    puts "\tNAME: $i\t\tLAST NAME: $new_names($i)"
}

# Unattach the array and close the database. The argument 1 specifies that
# the array itself should be kept, so ALL entries from the database are 
# copied into memory
puts "Closing database"
dbm_unattach new_names 1

puts "Removing database"
exec rm demo.db 



