//	Persistence of Vision Ray Tracer Scene Description File
//	File: solid.pov
//	Date: 27-09-2000
//	Author: Ren Smellenbergh
//	Demo: getting colors and normals from a color_map or normal_map with the solid pattern
//	First two rows are randomly picked, the last two in a linear way.

#version unofficial MegaPov 0.6;

global_settings {
	assumed_gamma 1.8
}

camera {
	location <0.0, 0.0, -18>
	up y*image_height right x*image_width
	angle 40
	look_at <0.0, 0.0, 0.0>
}

light_source { <2000, 3000, -6000>  rgb 1.2 }

background { rgb <0.2, 0, 0> }

#declare C = 0;
#declare Copies = 12;
#while ( C < Copies)
	sphere {
		<0.0, 0.0, 0.0>, 0.5
		texture {
			pigment {
				solid rand(seed(C))
				color_map {
					[ 0.0 rgb <0.834806, 0.746777, 0.605188> ]
					[ 0.12 rgb <0.719982, 0.583948, 0.239994> ]
					[ 0.23 rgb <0.797894, 0.577569, 0.342077> ]
					[ 0.5 rgb <0.555993, 0.373999, 0.244007> ]
					[ 0.7 rgb <0.613184, 0.374868, 0.226795> ]
					[ 1.0 rgb <0.523568, 0.272648, 0.156405> ]
				}
			}
			normal {
				solid rand(seed(C))
				normal_map {
					[ 0.0 agate bump_size 0.8 scale 0.3 ]
					[ 0.5 granite 0.6 scale 0.5 ]
					[ 1.0 crackle ]
				}
			}
			finish { phong 1.0  phong_size 500 }
		}
		translate x * (-5.5 + (C * (5.5 - (-5.5))/(Copies -1)))
		translate y *3
	} //object
	#declare C = C +1;
#end  //while (C < Copies)

#declare C = 0;
#declare Copies = 12;
#while ( C < Copies)
	sphere {
		<0.0, 0.0, 0.0>, 0.5
		texture {
			pigment {
				solid rand(seed(C))
				color_map {
					[ 0.0 rgb <0.976608, 0.951720, 0.763378> ]
					[ 0.12 rgb <0.946807, 0.810803, 0.773190> ]
					[ 0.23 rgb <0.955001, 0.751980, 0.744976> ]
					[ 0.5 rgb <0.909804, 0.650187, 0.810315> ]
					[ 0.7 rgb <0.700710, 0.682887, 0.897093> ]
					[ 0.8 rgb <0.618387, 0.811933, 0.901595> ]
					[ 1.0 rgb <0.591974, 0.928008, 0.731991> ]
				}
			}
			normal {
				solid rand(seed(C))
				normal_map {
					[ 0.0 agate bump_size 0.8 scale 0.3 ]
					[ 0.1 quilted 0.5 scale 0.3 ]
					[ 0.2 leopard 0.3 scale 0.1 ]
					[ 0.3 bozo 0.6 scale 0.1 ]
					[ 0.4 granite 0.6 scale 0.5 ]
					[ 0.5 marble 0.8 scale 0.2 turbulence 0.2 ]
					[ 0.6 granite 0.6 scale 0.5 ]
					[ 0.7 dents 0.6 scale 0.5 ]
					[ 0.8 wrinkles 0.6 scale 0.25 ]
					[ 0.9 ripples 1.2 scale 0.2 ]
					[ 1.0 crackle scale 0.5]
				}
			}
			finish { phong 1.0  phong_size 500 }
		}
		translate x * (-5.5 + (C * (5.5 - (-5.5))/(Copies -1)))
		translate y *1
	} //object
	#declare C = C +1;
#end  //while (C < Copies)

#declare C = 0;
#declare Copies = 12;

#while ( C < Copies)
	sphere {
		<0.0, 0.0, 0.0>, 0.5
		texture {
			pigment {
				solid (C/(Copies -1))
				color_map {
					[ 0.0 rgb <0.834806, 0.746777, 0.605188> ]
					[ 0.12 rgb <0.719982, 0.583948, 0.239994> ]
					[ 0.23 rgb <0.797894, 0.577569, 0.342077> ]
					[ 0.5 rgb <0.555993, 0.373999, 0.244007> ]
					[ 0.7 rgb <0.613184, 0.374868, 0.226795> ]
					[ 1.0 rgb <0.523568, 0.272648, 0.156405> ]
				}
			}
			normal {
				solid (C/(Copies -1))
				normal_map {
					[ 0.0 agate bump_size 0.8 scale 0.3 ]
					[ 0.5 granite 0.6 scale 0.5 ]
					[ 1.0 crackle ]
				}
			}
			finish { phong 1.0  phong_size 500 }
		}
		translate x * (-5.5 + (C * (5.5 - (-5.5))/(Copies -1)))
		translate y * (-1)
	} //object
	#declare C = C +1;
#end  //while (C < Copies)

#declare C = 0;
#declare Copies = 12;
#while ( C < Copies)
	sphere {
		<0.0, 0.0, 0.0>, 0.5
		texture {
			pigment {
				solid (C/(Copies -1))
				color_map {
					[ 0.0 rgb <0.976608, 0.951720, 0.763378> ]
					[ 0.12 rgb <0.946807, 0.810803, 0.773190> ]
					[ 0.23 rgb <0.955001, 0.751980, 0.744976> ]
					[ 0.5 rgb <0.909804, 0.650187, 0.810315> ]
					[ 0.7 rgb <0.700710, 0.682887, 0.897093> ]
					[ 0.8 rgb <0.618387, 0.811933, 0.901595> ]
					[ 1.0 rgb <0.591974, 0.928008, 0.731991> ]
				}
			}
			normal {
				solid (C/(Copies -1))
				normal_map {
					[ 0.0 agate bump_size 0.8 scale 0.3 ]
					[ 0.1 quilted 0.5 scale 0.3 ]
					[ 0.2 leopard 0.3 scale 0.1 ]
					[ 0.3 bozo 0.6 scale 0.1 ]
					[ 0.4 granite 0.6 scale 0.5 ]
					[ 0.5 marble 0.8 scale 0.2 turbulence 0.2 ]
					[ 0.6 granite 0.6 scale 0.5 ]
					[ 0.7 dents 0.6 scale 0.5 ]
					[ 0.8 wrinkles 0.6 scale 0.25 ]
					[ 0.9 ripples 1.2 scale 0.2 ]
					[ 1.0 crackle scale 0.5]
				}
			}
			finish { phong 1.0  phong_size 500 }
		}
		translate x * (-5.5 + (C * (5.5 - (-5.5))/(Copies -1)))
		translate y *-3
	} //object
	#declare C = C +1;
#end  //while (C < Copies)
