//	Persistence of Vision Ray Tracer Scene Description File
//	File: pattern_hf.pov
//	Date: 14/11/99
//	Showing use of pattern for height_fields
	
#version unofficial MegaPov 0.4;


camera {
	perspective 
	location <0.0, 0.0, -4>
	look_at <0.0, 0.0, 0.0>
	angle 40
	rotate x*45
}

light_source {
	<2.0, 40, -80>
	rgb <1.0, 1.0, 1.0>*1.3 
}
//#declare Kind = 3;	//1=hf;	2=cylinder image map;	3=sphere bump_map

height_field {		//height_field right-back generated from a leopard pattern
	pattern 100, 100 {
		hf_gray_16
		leopard
		color_map {
			[ 0.0 rgb 0.1 ]
			[ 0.3 rgb 0.05 ]
			[ 1.0 rgb 0.0 ]
		}
		scale 0.05
		sine_wave
	}
	smooth
	texture { pigment { rgb 0.75 } }
}

height_field {		//height_field left-back generated from an onion pattern
	pattern 100, 100 {
		hf_gray_16
		onion
		color_map {
			[ 0.0 rgb 0.1 ]
			[ 0.5 rgb 0.05 ]
			[ 1.0 rgb 0.0 ]
		}
		scale 0.1
		sine_wave
	}
	smooth
	texture { pigment { color rgb 0.85} }
	translate <-1, 0.0, 0.0>
}

height_field {		//height_field left-front generated from a radial pattern
	pattern 100, 100 {
		hf_gray_16
		radial
		color_map {
			[ 0.0 rgb 0.05 ]
			[ 0.5 rgb 0.025 ]
			[ 1.0 rgb 0.0 ]
		}
		frequency 30
		scallop_wave
	}
	smooth
	texture { pigment { color rgb 0.85} }
	translate <-1.0, 0.0, -1.0>
}

height_field {		//height_field right-front generated from a metric crackle pattern
	pattern 100, 100 {
		hf_gray_16
		crackle metric 2.5
		color_map {
			[ 0.0 rgb 0.05 ]
			[ 0.3 rgb 0.025 ]
			[ 1.0 rgb 0.0 ]
		}
		scale 0.1
		poly_wave 1.5
	}
	smooth
	texture { pigment { rgb 0.85 } }
	translate <0.0, 0.0, -1.0>
}
