/* isoblob_tree.pov */
#version unofficial MegaPov 0.4;

#include "colors.inc"
#include "textures.inc"

camera {
  location -10*z
  direction z*1.5
  up y right x*4/3
  look_at 0
  }

background {color 0.5}
light_source {<-5,5,-5> color White}

isoblob {
  threshold 0.1
  accuracy 0.001
  max_trace 10

  function {max((1-sqrt(sqr(x)+sqr(y)+noise3d(r*3,s*3,t*3)/3))*min(1,6-z),0)}
  function {
      max( (1-sqrt(sqr(x)+sqr(y+max(abs(z-4)-3,0)*0.25)
            + min(z-1,0)*0.25+noise3d(r*3,s*3,t*3)/5))
           * min(1,6-z) ,0)
      }

  cylinder {<0,0,0> <0,6,0> 1 strength 0.5 function 1 scale 0.5}
  cylinder {<0,0,0> <0,0,6> 1.5 strength 0.25 function 2 scale 0.35 rotate -30*x translate y*3}
  cylinder {<0,0,0> <0,0,6> 1.5 strength 0.25 function 2 scale 0.35 rotate -30*x rotate y*120 translate y*3}
  cylinder {<0,0,0> <0,0,6> 1.5 strength 0.25 function 2 scale 0.35 rotate -30*x rotate y*240 translate y*3}
  cylinder {<0,0,0> <0,6,0> 1 strength 0.4 function 1 scale 0.35 translate y*3}
  cylinder {<0,0,0> <0,0,6> 1.5 strength 0.25 function 2 scale 0.2 rotate -30*x translate y*5.5*0.35 rotate 60*x translate y*3}
  cylinder {<0,0,0> <0,0,6> 1.5 strength 0.25 function 2 scale 0.2 rotate -30*x rotate y*120 translate y*5.5*0.35 rotate 60*x translate y*3}
  cylinder {<0,0,0> <0,0,6> 1.5 strength 0.25 function 2 scale 0.2 rotate -30*x rotate y*240 translate y*5.5*0.35 rotate 60*x translate y*3}
  cylinder {<0,0,0> <0,0,6> 1.5 strength 0.25 function 2 scale 0.2 rotate -30*x translate y*5.5*0.35 rotate 60*x rotate y*120 translate y*3}
  cylinder {<0,0,0> <0,0,6> 1.5 strength 0.25 function 2 scale 0.2 rotate -30*x rotate y*120 translate y*5.5*0.35 rotate 60*x rotate y*120 translate y*3}
  cylinder {<0,0,0> <0,0,6> 1.5 strength 0.25 function 2 scale 0.2 rotate -30*x rotate y*240 translate y*5.5*0.35 rotate 60*x rotate y*120 translate y*3}
  cylinder {<0,0,0> <0,0,6> 1.5 strength 0.25 function 2 scale 0.2 rotate -30*x translate y*5.5*0.35 rotate 60*x rotate y*240 translate y*3}
  cylinder {<0,0,0> <0,0,6> 1.5 strength 0.25 function 2 scale 0.2 rotate -30*x rotate y*120 translate y*5.5*0.35 rotate 60*x rotate y*240 translate y*3}
  cylinder {<0,0,0> <0,0,6> 1.5 strength 0.25 function 2 scale 0.2 rotate -30*x rotate y*240 translate y*5.5*0.35 rotate 60*x rotate y*240 translate y*3}

  texture {pigment {color rgb<0.6,0.45,0.3>}}

  rotate y*20
  translate -3*y
  }