// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

#version unofficial MegaPov 0.4;

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
  //timestamp 1,5
  motion_blur 5,0.06
}

// ----------------------------------------
camera
{
  location  <0.0, 0.5, -4.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------
plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}


$blur=yes;

#if(blur)

motion_blur{
  union{
    sphere { 0.0, 1}
    box{-1,1 scale .5 translate 1*y}
    texture {pigment {radial frequency 8} finish{specular 1}}
  }
  scale .6
  translate clock*y
}

#else
  
  sphere { 0.0, 1 texture {pigment {radial frequency 8} finish{specular 1}} 
  scale .6
  }

#end

