//	Persistence of Vision Ray Tracer Scene Description File
//	File: chrono.pov
//	Date: 27/12/99
//	Author: Yvo Smellenbergh
//	Demo: writing parsing time to the image.
#version unofficial MegaPov 0.4;
global_settings {
	assumed_gamma 1.8
	ini_option "Width=650"				
	ini_option "End_Column=650"
	ini_option "Height=140"
	ini_option "End_Row=140"
}

//Get the clock and set the internal counter to zero.
//When reading again withthe current_chrono keyword, you get the seconds between
//start_chrono and current_chrono
#declare ParseStart=start_chrono;

camera {
	location <0.0, 0.5, -10>
	up y*image_height right x*image_width
	angle 60
	look_at <0.0, 0.5, 0.0>
}

light_source { <1000, 1000, -10000> 	rgb 1.4 }
	
background { rgb <0.8, 0.8, 0.8> }

#declare C = 0;
#declare Copies = 2000;

#while ( C < Copies)
	sphere {
		<0.0, 0.0, 0.0>, 0.035
		translate y * (-0.4)
		rotate x * (0 + (C * (360*20)/(Copies -1)))
		translate x * (-4 + (C * (4 - (-4))/(Copies -1)))
		#declare R = (1.000000 + (C * (0.978378 -(1.000000))/(Copies -1)));
		#declare G = (0.000000 + (C * (1.000000 -(0.000000))/(Copies -1)));
		#declare B = (0.000000 + (C * (0.350027 -(0.000000))/(Copies -1)));
		texture { pigment { 	rgb <R, G, B> } }
		translate y*0.8
	} //object
	#declare C = C +1;
#end  //while (C < Copies)

//done, get the elapsed time
#declare ParseEnd=current_chrono;	//reads the seconds elapsed since start_chrono

//*********** write time value to the scene *******************
text {		
	ttf "arial.ttf",
	concat("Parsing took ",str( ParseEnd,3,3), " seconds")
	0.1, <-0.0, 0.0, 0.0>
	align_center
	texture { pigment { rgb <0.899992, 0.626368, 0.216022> } }
	scale <0.8,1,1>
	translate y*-0.5
}


