// MegaPov scene file, demo for complex functions use.
// An arbitrary Julia set, different from those built-in to POV-Ray
// Note: parsed at least 173 seconds
#version unofficial MegaPov 0.4;

#include "colors.inc"

#macro cAbs2(c1)
    c1.x*c1.x+c1.y*c1.y
#end

#declare a=<0,0>;
#declare Lambda=<1,.4>; // 'lambda'

#declare A=64;          // 'bailout'
#declare iilim=40;      // recursion limit
// a type of Julia set
#macro Lambdafn(xx,zz)                
/*===================================================================*/
        // c0 = xx + i*zz
	#local cn=<xx,zz>;
        #local ii=0;
        #local rr=cAbs2(cn);
        #while(ii<iilim & rr<A)
           // c(n+1)=Lambda*sin(c(n))+a           
           #local cn=cmult(Lambda,csin(cn))+a;
           #local rr=cAbs2(cn);
		   #local ii=ii+1;
	#end
        ii
/*===================================================================*/
#end

camera { location <0, 20, 15> direction <0, 0, 6.0> look_at <0,0,0> }

light_source {4*<50, 180, 30> color White}
light_source {4*<60, 180, 30> color White}

blob{ threshold .5
        #local xmin=-3;#local xmax=3;
        #local zmin=-2;#local zmax=2;
        
        #local xsamples=240;
        #local zsamples=160;                                                                           
        
        #local dxx=(xmax-xmin)/xsamples;        
        #local dzz=(zmax-zmin)/zsamples;
        #local sr=sqrt(dxx*dxx+dzz*dzz);

        #local xx=xmin;
        #local xi=0;
        #while(xi<xsamples)            
            #local zz=zmin;
            #local zi=0;
            #while(zi<zsamples)   
                    #local d=Lambdafn(xx,zz);
		    #if(d>20)
		      
		      #local cp=pi*d/iilim;
		      #local pigm=
		          pigment{rgb<
		                      cos(3*cp+pi/2),
		                      sin(4*cp+pi/4),
		                      cos(3*cp)
		                     >
		                  }
		     
		      sphere{<xx,0,zz>,sr*(d/iilim),2*(d/iilim) pigment{pigm}}
		      
		    #end
                    #local zz=zz+dzz;
                    #local zi=zi+1;                        
            #end
            #local xx=xx+dxx;              
            #local xi=xi+1;
        #end                            
}

sky_sphere{
  pigment{
   bozo
   color_map { [0.0 color rgb <0.7,0.7,0.7>] [1.0 color rgb <0.5,0.7,1>] }
   scale .1
  }  
}

