/****************************************************************************
*                pvedit.h
*
*  This file contains editor support code.
*
*  Copyright  POV-Team 1996-2002. All Rights Reserved.
*  This windows version of POV-Ray is Copyright 1996-2002 Christopher J. Cason.
*  Author : Christopher J. Cason
*
*  NOTE : As this is Windows code, it was edited using a wide Windows-hosted
*         editor. Accordingly, expect text to exceed 80 columns regularly.
*
*  from Persistence of Vision Raytracer
*  Copyright 1996-2002 Persistence of Vision Team
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray and to port the software to platforms other
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file. If
*  POVLEGAL.DOC is not available it may be found online at the following URL:
*
*    http://www.povray.org/povlegal.html.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
* $Id: //depot/povray/3.5/windows/pvedit.h#11 $
*
*****************************************************************************/

#define EDITDLLVERSION            0x0210

#define EDIT_CAN_OPEN             0x01
#define EDIT_CAN_CLOSE            0x02
#define EDIT_CAN_WRITE            0x04
#define EDIT_CAN_UNDO             0x08
#define EDIT_CAN_REDO             0x10
#define EDIT_MSG_SELECTED         0x20
#define EDIT_CURRENT_MODIFIED     0x40
#define EDIT_ANY_MODIFIED         0x80

#define RENDER_MESSAGE            WM_USER + 1000
#define CREATE_RENDERWIN_MESSAGE  WM_USER + 1005
#define CLOSE_EDITOR_MESSAGE      WM_USER + 1010
#define CREATE_EDITOR_MESSAGE     WM_USER + 1015
#define EDITOR_RENDER_MESSAGE     WM_USER + 1020
#define SHOW_MESSAGES_MESSAGE     WM_USER + 1025
#define KEYWORD_LOOKUP_MESSAGE    WM_USER + 1030
#define RENDERWIN_CLOSE_MESSAGE   WM_USER + 1035
#define HIDE_NEWUSER_HELP_MESSAGE WM_USER + 1040
#define COPY_COMMANDLINE_MESSAGE  WM_USER + 1045
#define TASKBAR_NOTIFY_MESSAGE    WM_USER + 1100 // reserved 1100-1199
#define GUIEXT_CREATE_EDITOR      WM_USER + 1200 // reserved 1200-1299

#define REGKEY                    "POV-Ray"

enum
{
  GetFileMenu,
  GetEditMenu,
  GetSearchMenu,
  GetTextMenu,
  GetInsertMenu,
  GetOptionsMenu,
  GetAppearanceMenu
} ;

enum
{
  NotifyTabChange,
  NotifyEditStateChange,
  NotifyModifiedChange
} ;

typedef enum
{
  StatusMessage,
  StatusLine,
  StatusCol,
  StatusIns,
  StatusModified,
  StatusPPS,
  StatusRendertime,
  StatusLast
} StatusBarSection ;

bool LoadEditorDLL (char *shortdllname, char *dllname) ;
HWND InitialiseEditor (HWND ParentWindow, HWND StatusWindow, char *HomePath) ;
void SetEditorPosition (int x, int y, int w, int h) ;
void EditSetMessageWindow (HWND MessageWindow) ;
void EditRestoreState (int RestoreFiles) ;
void EditSaveState (void) ;
bool EditSelectFile (char *FileName) ;
bool EditBrowseFile (bool CreateNewWindow) ;
bool EditOpenFile (char *FileName) ;
bool EditCloseFile (char *FileName) ;
bool EditSaveFile (char *FileName) ;
bool EditExternalOpenFile (char *ParamString) ;
DWORD EditGetTab (void) ;
DWORD EditGetFlags (void) ;
char *EditGetFilename (void) ;
void EditNextTab (bool Forward) ;
bool EditCanClose (bool AllFiles) ;
bool EditSaveModified (char *FileName) ;
bool EditEnabled (void) ;
void EditSetState (bool on) ;
void EditShowMessages (bool on) ;
void EditDispatchMenuId (DWORD id) ;
void EditSetVisible (bool visible) ;
HMENU EditGetMenu (int which) ;
void EditUnload (void) ;
void EditSetNotifyBase (HWND WindowHandle, int MessageBase) ;
void EditUpdateMenus (HMENU MenuHandle) ;
void EditContextHelp (void) ;
void EditSetFocus (void) ;
bool EditShowParseError (char *FileName, char *Message, int Line, int Col) ;
bool EditPassOnMessage (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam, DWORD *rVal) ;
void EditSetKeywords (LPCSTR Keywords) ;

