/****************************************************************************
*                   source\windows\fasternoise.h
*
*  This file contains the Windows specific noise function tweaks.
*
*  from Persistence of Vision Raytracer
*  Copyright 1996-2002 Persistence of Vision Team
*  This windows version of POV-Ray is Copyright 1996-2002 Christopher J. Cason.
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray and to port the software to platforms other
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file. If
*  POVLEGAL.DOC is not available it may be found online at the following URL:
*
*    http://www.povray.org/povlegal.html.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
* $File: //depot/povray/3.5/windows/fasternoise.h $
* $Revision: #4 $
* $Change: 1814 $
* $DateTime: 2002/07/27 10:19:15 $
* $Author: chrisc $
* $Log$
*
*****************************************************************************/

/*****************************************************************************/
/* Intel SSE2 support                                                        */
/*****************************************************************************/

#ifndef WIN_FASTERNOISE_H
#define WIN_FASTERNOISE_H

#ifdef USE_INTEL_SSE2
int SSE2ALREADYDETECTED = 0 ;
DBL OriNoise(VECTOR EPoint, TPATTERN *TPat) ;
void OriDNoise(VECTOR result, VECTOR EPoint) ;
#include "emmintrin.h"
#include "intelsse2.h"
#undef ALIGN16
#define ALIGN16 __declspec(align(16))
#endif

#endif
