/****************************************************************************
*
*  This file is part of the CodeMax editor support code.
*
*  Copyright  POV-Team(tm) 1996-2002. All Rights Reserved.
*  This windows version of POV-Ray is Copyright 1996-2002 Christopher J. Cason.
*  Author : Christopher J. Cason.
*
*  from Persistence of Vision Raytracer(tm)
*  Copyright 1996-2002 Persistence of Vision Team
*
* The terms POV-Ray, POV, and Persistence of Vision Raytracer are trademarks
* of the Persistence of Vision Team.
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray(tm) and to port the software to platforms
*  other than those supported by the POV-Ray Team. There are strict rules
*  under which you are permitted to use this file. The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file. If
*  POVLEGAL.DOC is not available it may be found online at the following URL:
*
*    http://www.povray.org/povlegal.html.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
* Thanks to the makers of PERFORCE (http://www.perforce.com/) for donating the
* copy of their Perforce revision control system that is now used to maintain
* the POVWIN source. Thanks also to WinMain Software (http://www.winmain.com/)
* for providing the (at the time commercial) CodeMax edit control which the POVWIN
* 3.1 editor is based upon.
*
* $File: //depot/povray/3.5/windows/codemax/component/CTabControl.cpp $
* $Revision: #3 $
* $Change: 1816 $
* $DateTime: 2002/07/27 10:29:18 $
* $Author: chrisc $
* $Log$
*
*****************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "CTabControl.h"
#pragma package(smart_init)
//---------------------------------------------------------------------------
// ValidCtrCheck is used to assure that the components created do not have
// any pure virtual functions.
//

static inline void ValidCtrCheck(TCTabControl *)
{
  new TCTabControl(NULL);
}
//---------------------------------------------------------------------------
__fastcall TCTabControl::TCTabControl(TComponent* Owner) : TTabControl(Owner)
{
}
//---------------------------------------------------------------------------
namespace Ctabcontrol
{
  void __fastcall PACKAGE Register()
  {
    TComponentClass classes[1] = {__classid(TCTabControl)};
    RegisterComponents("Additional", classes, 0);
  }
}
//---------------------------------------------------------------------------
void __fastcall TCTabControl::CreateParams (Controls::TCreateParams &Params)
{
  TTabControl::CreateParams (Params) ;
  Params.Style = WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS ;
}

void __fastcall TCTabControl::WndProc (Messages::TMessage &Message)
{
//if (Message.Msg == WM_ERASEBKGND)
//{
//  Message.Result = 0 ;
//  return ;
//}
  TTabControl::WndProc (Message) ;
}

