# IBM Makefile for Persistence of Vision Raytracer for Watcom C++ for Windows
# Version 10.5
# For use with the Watcom C++ protected mode compiler on the IBM-PC.
#
# Builds the PVENGINE.EXE executable. Depends on a number of libraries,
# including the POVWAT.LIB containing the POV-Ray object files.

# Use Watcom suggested "performance" options.
# Use /5r in place of /4r for a Pentium optimized compile.
# Use /fp5 to optimize for Pentium FPU 
#
# /zq turns on quiet mode (easier on the eyes ;-)
# /fh /fhq turns on pre-compiled headers with PCH warnings turned off
# /s turns off stack frame checking (faster)
# /bt=nt compiled for Win32

#directory macros
S=..\..\
M=..\

# 'standard' optimisations (which includes pipelining etc.)
CFLAGS=-c-zq-bt=nt-fpi87-fp5-zp4-5r-w5-s-oneatx -i=$(S) -i=$(M)

# these are 486 optimisations
# CFLAGS=-c-zq-bt=nt-fpi87-fp3-zp4-4r-w5-s-oneatxi -i=$(S) -i=$(M)

# Uncomment the following to turn on debug information
#
#CFLAGS_DBG=-d2
#LIBFLAGS_DBG=/d128
#CFLAGS=-c-zq-bt=nt-fpi87-fp5-zp4-5r-w5-s-oneatx -i=$(S) -i=$(M) -DCOMMONCTRL_VERSION=0x0400

# Uncomment the following for normal, non-debug compiles
CFLAGS=-c-zq-bt=nt-fpi87-fp5-zp4-5r-w5-s-oneatx -i=$(S) -i=$(M) -DCOMMONCTRL_VERSION=0x0400

C=wcl386 $(CFLAGS) $(CFLAGS_DBG)

RCFLAGS=/bt=nt /i=$(M)
RC=wrc /r $(RCFLAGS)

PVOBJS = pvengine.obj pvfiles.obj pvmisc.obj pvtext.obj pvbitmap.obj pvedit.obj &
         pvbmp.obj pvmenu.obj pvdialog.obj pvguiext.obj

# POV-Ray Specific Dependencies
#
pvengine.exe : $(PVOBJS) $(M)pvengine.res
    wlink @pvengine.lnk
    wrc $(M)pvengine.res pvengine.exe

#
# Specific module/header dependencies for POV-Ray:
#

pvengine.obj : $(M)pvengine.c
    $(C) $(M)pvengine.c

pvfiles.obj : $(M)pvfiles.c
    $(C) $(M)pvfiles.c

pvmisc.obj : $(M)pvmisc.c
    $(C) $(M)pvmisc.c

pvtext.obj : $(M)pvtext.c
    $(C) $(M)pvtext.c

pvbitmap.obj : $(M)pvbitmap.c
    $(C) $(M)pvbitmap.c

pvbmp.obj : $(M)pvbmp.c
    $(C) $(M)pvbmp.c

pvmenu.obj : $(M)pvmenu.c
    $(C) $(M)pvmenu.c

pvdialog.obj : $(M)pvdialog.c
    $(C) $(M)pvdialog.c

pvguiext.obj : $(M)pvguiext.c
    $(C) $(M)pvguiext.c

pvedit.obj : $(M)pvedit.c
    $(C) $(M)pvedit.c

$(M)pvengine.res: $(M)pvengine.rc
    $(RC) $(M)pvengine.rc
