/**************************************************************************************************
	$Header: /pub/cvsroot/yencode/src/output.h,v 1.6 2002/03/10 16:25:52 bboy Exp $

	Copyright (C) 2002  Don Moore <bboy@bboy.net>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at Your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**************************************************************************************************/


#ifndef _YOUTPUT_H
#define _YOUTPUT_H


/* Strip path from filename if opt_strip_paths is set */
extern char *strip_path(char *filename);

/* Open output file, prompting for overwrite if necessary */
extern FILE *open_output_file(const char *output_filename, int overwrite, const char *input_filename);

/* Rename an output file (in case of error) */
extern char *rename_output_file(const char *filename, const char *errmsg);

/* Output message to user */
extern void usermsg(const char *output_filename, const char *input_filename,
						  int input_part_number, int total_part_number,
						  char *error_message, const char *fmt, ...);


#endif /* !_YOUTPUT_H */

/* vi:set ts=3: */
