/*  Xsqlmenu
 *  Copyright (C) 1996-2000 Kees Lemmens
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include "forms.h"

#include "Xsqldefs.h"
#include "version.h"
#ifdef USE_MYSQL
#include "mysql.xpm"
#else
#include "msql2_now.xpm"
#endif

/* Global variables */

#ifdef USE_MYSQL
MYSQL *sock;
#else
int      sock;
#endif
int countflag;

/* some simple callbacks */

void XsqlInfo(FL_OBJECT *ob, long parent)
{
   fl_show_message(
	"Xsqlmenu: a powerful MiniSQL/MySQL frontend build using the Xforms library",
	"by Kees Lemmens, The Netherlands (C) 1996," VERSION,
	"MySQL compatibility by Stephen A. Wood, August 2000");
}

void XsqlExit(FL_OBJECT *ob, long parent)
{
#ifndef FORMS081
   if(! fl_show_question("Do you want to quit ?",1))
     return;
#else
   if(! fl_show_question("Do you want to quit ?","",""))
     return;
#endif
     
   sql_close(sock);
   exit(0);
}

void XsqlSetNewServer(FL_OBJECT *ob, long parent)
{
   SetNewServer((char *)fl_get_input(ob),(FD_Xsql *)parent);
}

void XsqlSetNewDatabase(FL_OBJECT *ob, long parent)
{
   SetNewDatabase((char *)fl_get_choice_text(ob),(FD_Xsql *)parent);
}

void XsqlSetNewTable(FL_OBJECT *ob, long parent)
{
   SetNewTable((char *)fl_get_choice_text(ob),(FD_Xsql *)parent);
}

/* end simple callbacks */

void Usage(char *naam)
{
   fprintf(stderr,"\nUsage  : %s [options] [<database> [<table>]]\n",naam);
   fprintf(stderr,  "Options: -h <host> : set remote database server\n");
   fprintf(stderr,  "         -c        : disable record count display\n");
   exit(1);
}

void Initialize(int argc,char *argv[],FD_Xsql *fd_Xsql)
{
   char *basename;
   int sf=0,x;
      
   basename=argv[0];
   
   fd_Xsql->vdata = NULL; /* Set hook for Info Structs to empty */

   x=argc;
   while(--x>0)                    /* parse options */
   {
      if(*argv[1]=='-')
      {
	 switch(*(++argv[1]))
	 {
	  case 'c':  countflag = NOCOUNT; break;
	  case 'h':
	    SetNewServer(argv[2],fd_Xsql); sf=1;
	    ++argv; --argc; --x;     break;
	  default:  Usage(basename); break;
	 }
	 ++argv; --argc;
      }
   }
   
   if(argc > 3)
     Usage(basename);

   if(sf == 0)
     SetNewServer(NULL,fd_Xsql);
   
#ifdef USE_MYSQL
   fl_set_pixmap_data(fd_Xsql->Logo,mysqllogo);
#else
   fl_set_pixmap_data(fd_Xsql->Logo,msql2logo);
#endif
#ifndef FORMS081
   fl_set_browser_hscrollbar(fd_Xsql->XsqlMessages,FL_ON);
   fl_set_browser_vscrollbar(fd_Xsql->XsqlMessages,FL_ON);
#endif
   fl_set_goodies_font(FL_NORMAL_TEXT,12); /* font for warnings ed. */

   if(argc >= 2)
     SetNewDatabase(argv[1],fd_Xsql);
   if(argc == 3)
     SetNewTable(argv[2],fd_Xsql);
}

int main(int argc, char *argv[])
{
   FD_Xsql *fd_Xsql;

   fl_initialize(&argc, argv, 0, 0, 0);
   
   fd_Xsql = create_form_Xsql();

   /* fill-in form initialization code */
   Initialize(argc,argv,fd_Xsql); /* set socket, database and tablename */

   /* show the first form */
   fl_show_form(fd_Xsql->Xsql,FL_PLACE_CENTER,FL_FULLBORDER,"Xsql");

   while(1)
     fl_do_forms();

   sql_close(sock);

   return 0;
}
